/**
 * CardNavigation 部件模型
 *
 * @export
 * @class CardNavigationModel
 */
export default class CardNavigationModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof CardNavigationDataviewexpbar_dataviewMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'amount',
				prop: 'amount',
				dataType: 'FLOAT',
			},
			{
				name: 'ibizcustomerid',
				prop: 'ibizcustomerid',
				dataType: 'PICKUP',
			},
			{
				name: 'memo',
				prop: 'memo',
				dataType: 'LONGTEXT_1000',
			},
			{
				name: 'orderstate',
				prop: 'orderstate',
				dataType: 'SSCODELIST',
			},
			{
				name: 'detailnum',
				prop: 'detailnum',
				dataType: 'INT',
			},
			{
				name: 'ibizorderid',
				prop: 'ibizorderid',
				dataType: 'GUID',
			},
			{
				name: 'ibizcustomername',
				prop: 'ibizcustomername',
				dataType: 'PICKUPTEXT',
			},
			{
				name: 'wfstep',
				prop: 'wfstep',
				dataType: 'SSCODELIST',
			},
			{
				name: 'ibizordername',
				prop: 'ibizordername',
				dataType: 'TEXT',
			},
			{
				name: 'srfmstag',
			},
			{
				name: 'srfmajortext',
				prop: 'ibizordername',
				dataType: 'TEXT',
			},
			{
				name: 'srfkey',
				prop: 'ibizorderid',
				dataType: 'GUID',
			},

			{
				name: 'ibizorder',
				prop: 'ibizorderid',
				dataType: 'FONTKEY',
			},


      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      {
        name:'srfparentdata',
        prop:'srfparentdata'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}