/**
 * CustomCalendar 部件模型
 *
 * @export
 * @class CustomCalendarModel
 */
export default class CustomCalendarModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof CustomCalendarCalendarMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof CustomCalendarCalendarMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'color',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "item":
              dataItems = [...dataItems,
                  {
                    name: 'ibizbook',
                    prop: 'ibizbookid'
                  },
                  {
                    name: 'title',
                    prop: 'ibizbookname'
                  },
                  {
                    name:'start',
                    prop:'lendouttime'
                  },
                  {
                    name:'end',
                    prop:'returntime'
                  },
                  {
                    name:'srficon',
                    prop:'icon'
                  },
                  {
                    name:'srfdescription',
                    prop:'subtext'
                  },
                  {
                    name:'srfkey',
                    prop:'ibizbookid'
                  },
              ];
              break;
      }
      return dataItems;
	}

}