import ViewMessageService from '../view-message-service';
/**
 * 树视图---右键菜单和动态参数视图消息服务对象基类
 *
 * @export
 * @class ViewMsg56MessageServiceBase
 */
export default class ViewMsg56MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg56MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg56MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg56MessageServiceBase
     */
    public initBasicParam(){
        this.id = "1117BA0F-EDB5-4B19-92DD-274E1CC66AAF";
        this.name = "树视图---右键菜单和动态参数";
        this.codename = "ViewMsg56";
        this.title = "";
        this.content = "本示例展示树视图右键操作功能和动态参数过滤功能；其中在一级节点上配置了刷新全部数据行为，动态参数过滤见一级节点导航参数配置。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg56MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}