import ViewMessageService from '../view-message-service';
/**
 * 选项操作视图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg35MessageServiceBase
 */
export default class ViewMsg35MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg35MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg35MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg35MessageServiceBase
     */
    public initBasicParam(){
        this.id = "9D194F62-A579-4564-8A64-FFF6462D98D4";
        this.name = "选项操作视图";
        this.codename = "ViewMsg35";
        this.title = "";
        this.content = "本示例展示选项操作视图：选中表格某一项，点击编辑即可打开选项操作视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg35MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}