import ViewMessageService from '../view-message-service';
/**
 * 表格视图内置功能视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg18MessageServiceBase
 */
export default class ViewMsg18MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg18MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg18MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg18MessageServiceBase
     */
    public initBasicParam(){
        this.id = "63B4B466-272A-434D-BB9A-2434B1C72A46";
        this.name = "表格视图内置功能视图消息";
        this.codename = "ViewMsg18";
        this.title = "";
        this.content = "本示例展示实体表格视图内置功能；包括快速搜索代码表、快速搜索栏、搜索表单、快速搜索表单、工具栏等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg18MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}