import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 输出参数
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic-base.ts.ftl 生成
 * @export
 * @class PrintParamsUILogicBase
 */
export default class PrintParamsUILogicBase {

    /**
     * Creates an instance of  PrintParamsBase.
     * 
     * @param {*} [opts={}]
     * @memberof PrintParamsUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof PrintParamsUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '输出参数',
            codeName: 'printParam',
            entityParam: true,
        },
        {
            name: '应用全局',
            codeName: 'appGlobal',
            appGlobalParam: true,
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
        {
            name: '路由视图会话变量',
            codeName: 'routerSession',
            routeViewSessionParam: true,
        },
        {
            name: '当前视图会话变量',
            codeName: 'currentView',
            viewSessionParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof PrintParamsUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof PrintParamsUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof PrintParamsUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
    console.log(`已完成执行开始节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行设置testParam节点`);
        await this.execute_preparejsparam1_node(actionContext);
    }
    
    /**
     * 调试逻辑参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_debugparam4_node(actionContext: UIActionContext) {
        const dstParamValue = actionContext.getParam('appGlobal').getReal();
        console.log(`逻辑节点调试逻辑参数操作参数值:`,  Util.deepCopy(dstParamValue));
    console.log(`已完成执行调试逻辑参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行获取应用名称节点`);
        await this.execute_preparejsparam4_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = 'NONEVALUE';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
    console.log(`已完成执行结束节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
    }
    
    /**
     * 设置testParam
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_preparejsparam1_node(actionContext: UIActionContext) {
        try {
            //  目标数据
            const dstParam_1: any = actionContext.getParam('appGlobal');
            //  无值类型
            //  直接值
            const result_1 = '121';
            dstParam_1.set('testparam', result_1);
        } catch (error: any) {
            throw new Error(`逻辑节点 设置testParam ${error && error.message ? error.message : '发生未知错误！'}`);
        }
    console.log(`已完成执行设置testParam节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行调试逻辑参数节点`);
        await this.execute_debugparam1_node(actionContext);
    }
    
    /**
     * 获取全局testParam
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_preparejsparam2_node(actionContext: UIActionContext) {
        try {
            //  目标数据
            const dstParam_1: any = actionContext.getParam('routerSession');
            //  无值类型
            //  源逻辑参数、网页请求上下文、当前视图参数
            const srcParam_1 = actionContext.getParam('appGlobal');
            const result_1 = srcParam_1.get('testparam') ? srcParam_1.get('testparam') : null;
            dstParam_1.set('appglobalparam', result_1);
        } catch (error: any) {
            throw new Error(`逻辑节点 获取全局testParam ${error && error.message ? error.message : '发生未知错误！'}`);
        }
    console.log(`已完成执行获取全局testParam节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行调试逻辑参数节点`);
        await this.execute_debugparam2_node(actionContext);
    }
    
    /**
     * 调试逻辑参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_debugparam2_node(actionContext: UIActionContext) {
        const dstParamValue = actionContext.getParam('routerSession').getReal();
        console.log(`逻辑节点调试逻辑参数操作参数值:`,  Util.deepCopy(dstParamValue));
    console.log(`已完成执行调试逻辑参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行获取路由参数节点`);
        await this.execute_preparejsparam3_node(actionContext);
    }
    
    /**
     * 调试逻辑参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_debugparam3_node(actionContext: UIActionContext) {
        const dstParamValue = actionContext.getParam('currentView').getReal();
        console.log(`逻辑节点调试逻辑参数操作参数值:`,  Util.deepCopy(dstParamValue));
    console.log(`已完成执行调试逻辑参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行重置参数节点`);
        await this.execute_resetparam1_node(actionContext);
    }
    
    /**
     * 调试逻辑参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_debugparam5_node(actionContext: UIActionContext) {
        const dstParamValue = actionContext.getParam('printParam').getReal();
        console.log(`逻辑节点调试逻辑参数操作参数值:`,  Util.deepCopy(dstParamValue));
    console.log(`已完成执行调试逻辑参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 调试逻辑参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_debugparam1_node(actionContext: UIActionContext) {
        const dstParamValue = actionContext.getParam('appGlobal').getReal();
        console.log(`逻辑节点调试逻辑参数操作参数值:`,  Util.deepCopy(dstParamValue));
    console.log(`已完成执行调试逻辑参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行获取全局testParam节点`);
        await this.execute_preparejsparam2_node(actionContext);
    }
    
    /**
     * 重置参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_resetparam1_node(actionContext: UIActionContext) {
        const dstParam: any = actionContext.getParam('appGlobal');
        dstParam.resetAll();
        actionContext.bindLastReturnParam(null);
    console.log(`已完成执行重置参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行调试逻辑参数节点`);
        await this.execute_debugparam4_node(actionContext);
    }
    
    /**
     * 获取应用名称
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_preparejsparam4_node(actionContext: UIActionContext) {
        try {
            //  目标数据
            const dstParam_1: any = actionContext.getParam('printParam');
            //  无值类型
            //  环境参数
            const result_1 = Environment['AppName'];
            dstParam_1.set('envparam', result_1);
        } catch (error: any) {
            throw new Error(`逻辑节点 获取应用名称 ${error && error.message ? error.message : '发生未知错误！'}`);
        }
    console.log(`已完成执行获取应用名称节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行调试逻辑参数节点`);
        await this.execute_debugparam5_node(actionContext);
    }
    
    /**
     * 获取路由参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof PrintParamsUILogicBase
     */
    protected async execute_preparejsparam3_node(actionContext: UIActionContext) {
        try {
            //  目标数据
            const dstParam_1: any = actionContext.getParam('currentView');
            //  无值类型
            //  源逻辑参数、网页请求上下文、当前视图参数
            const srcParam_1 = actionContext.getParam('routerSession');
            const result_1 = srcParam_1.get('testparam') ? srcParam_1.get('testparam') : null;
            dstParam_1.set('testccc', result_1);
        } catch (error: any) {
            throw new Error(`逻辑节点 获取路由参数 ${error && error.message ? error.message : '发生未知错误！'}`);
        }
    console.log(`已完成执行获取路由参数节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行调试逻辑参数节点`);
        await this.execute_debugparam3_node(actionContext);
    }
    

}