package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
/**
 * 关系型数据实体[IBIZSample0016] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("项目成员")
public class IBIZSample0016SearchContext extends QueryWrapperContext<IBIZSample0016> {

    @JsonProperty("n_ibizsample0016id_eq")
    @JSONField(name = "n_ibizsample0016id_eq")
    @ApiModelProperty("项目成员标识EQ")
	private String ibizSample0016IdEQ;
	public IBIZSample0016SearchContext setIbizSample0016IdEQ(String ibizSample0016IdEQ) {
        this.ibizSample0016IdEQ = ibizSample0016IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0016IdEQ)){
            this.getSearchCond().eq("ibizsample0016id", ibizSample0016IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0016name_like")
    @JSONField(name = "n_ibizsample0016name_like")
    @ApiModelProperty("项目成员名称LIKE")
	private String ibizSample0016NameLIKE;
	public IBIZSample0016SearchContext setIbizSample0016NameLIKE(String ibizSample0016NameLIKE) {
        this.ibizSample0016NameLIKE = ibizSample0016NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0016NameLIKE)){
            this.getSearchCond().like("ibizsample0016name", ibizSample0016NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0015name_eq")
    @JSONField(name = "n_ibizsample0015name_eq")
    @ApiModelProperty("项目名称EQ")
	private String ibizSample0015NameEQ;
	public IBIZSample0016SearchContext setIbizSample0015NameEQ(String ibizSample0015NameEQ) {
        this.ibizSample0015NameEQ = ibizSample0015NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0015NameEQ)){
            this.getSearchCond().eq("ibizsample0015name", ibizSample0015NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0015name_like")
    @JSONField(name = "n_ibizsample0015name_like")
    @ApiModelProperty("项目名称LIKE")
	private String ibizSample0015NameLIKE;
	public IBIZSample0016SearchContext setIbizSample0015NameLIKE(String ibizSample0015NameLIKE) {
        this.ibizSample0015NameLIKE = ibizSample0015NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0015NameLIKE)){
            this.getSearchCond().like("ibizsample0015name", ibizSample0015NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0014name_eq")
    @JSONField(name = "n_ibizsample0014name_eq")
    @ApiModelProperty("员工名称EQ")
	private String ibizSample0014NameEQ;
	public IBIZSample0016SearchContext setIbizSample0014NameEQ(String ibizSample0014NameEQ) {
        this.ibizSample0014NameEQ = ibizSample0014NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0014NameEQ)){
            this.getSearchCond().eq("ibizsample0014name", ibizSample0014NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0014name_like")
    @JSONField(name = "n_ibizsample0014name_like")
    @ApiModelProperty("员工名称LIKE")
	private String ibizSample0014NameLIKE;
	public IBIZSample0016SearchContext setIbizSample0014NameLIKE(String ibizSample0014NameLIKE) {
        this.ibizSample0014NameLIKE = ibizSample0014NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0014NameLIKE)){
            this.getSearchCond().like("ibizsample0014name", ibizSample0014NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0015id_eq")
    @JSONField(name = "n_ibizsample0015id_eq")
    @ApiModelProperty("项目标识EQ")
	private String ibizSample0015IdEQ;
	public IBIZSample0016SearchContext setIbizSample0015IdEQ(String ibizSample0015IdEQ) {
        this.ibizSample0015IdEQ = ibizSample0015IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0015IdEQ)){
            this.getSearchCond().eq("ibizsample0015id", ibizSample0015IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0014id_eq")
    @JSONField(name = "n_ibizsample0014id_eq")
    @ApiModelProperty("员工标识EQ")
	private String ibizSample0014IdEQ;
	public IBIZSample0016SearchContext setIbizSample0014IdEQ(String ibizSample0014IdEQ) {
        this.ibizSample0014IdEQ = ibizSample0014IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0014IdEQ)){
            this.getSearchCond().eq("ibizsample0014id", ibizSample0014IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0016name", query)
            );
		}
	}
}