package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0018;
import cn.ibizlab.core.sample.filter.IBIZSample0018SearchContext;

public interface IBIZSample0018Service extends IService<IBIZSample0018> {

    default IBIZSample0018Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0018 get(IBIZSample0018 et);
    default IBIZSample0018 get(String key) {
        IBIZSample0018 et = new IBIZSample0018();
        et.setIbizSample0018Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0018> getByIds(Collection<String> ids) {
        List<IBIZSample0018> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0018 et = new IBIZSample0018();
            et.setIbizSample0018Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0018> getByEntities(List<IBIZSample0018> entities);

    IBIZSample0018 getDraft(IBIZSample0018 et);

    Integer checkKey(IBIZSample0018 et);

    boolean create(IBIZSample0018 et);
    boolean createBatch(List<IBIZSample0018> list);

    boolean update(IBIZSample0018 et);
    boolean updateBatch(List<IBIZSample0018> list);

    boolean save(IBIZSample0018 et);
    boolean saveBatch(List<IBIZSample0018> list);

    default boolean remove(String key) {
        IBIZSample0018 et = new IBIZSample0018();
        et.setIbizSample0018Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0018 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0018> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0018 et = new IBIZSample0018();
            et.setIbizSample0018Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0018> entities);

    Page<IBIZSample0018> searchDefault(IBIZSample0018SearchContext context);
    List<IBIZSample0018> listDefault(IBIZSample0018SearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}