package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0008", resultMap = "IBIZSample0008ResultMap")
@ApiModel(value = "IBIZSAMPLE0008", description = "自循环流程")
public class IBIZSample0008 extends EntityMP implements Serializable
{

    /**
     * 自循环步骤
     */
    @TableField(value = "wfstep")
    @DEField(name = "wfstep" , dict = "LPSTEP")
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty(value = "wfstep", notes = "自循环步骤")
    private String wfStep;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 业务状态
     */
    @TableField(value = "ywstate")
    @DEField(name = "ywstate")
    @JsonProperty("ywstate")
    @JSONField(name = "ywstate")
    @ApiModelProperty(value = "ywstate", notes = "业务状态")
    private String ywState;

    /**
     * 自循环流程标识
     */
    @Id
    @TableId(value = "ibizsample0008id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0008id" , isKeyField = true)
    @JsonProperty("ibizsample0008id")
    @JSONField(name = "ibizsample0008id")
    @ApiModelProperty(value = "ibizsample0008id", notes = "自循环流程标识")
    private String ibizSample0008Id;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @DEField(name = "wfversion")
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty(value = "wfversion", notes = "工作流版本")
    private String wfVersion;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流步骤")
    private Integer wfState;

    /**
     * 下一步处理人
     */
    @TableField(value = "nextperson")
    @DEField(name = "nextperson")
    @JsonProperty("nextperson")
    @JSONField(name = "nextperson")
    @ApiModelProperty(value = "nextperson", notes = "下一步处理人")
    private String nextPerson;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 自循环流程名称
     */
    @TableField(value = "ibizsample0008name")
    @DEField(name = "ibizsample0008name")
    @JsonProperty("ibizsample0008name")
    @JSONField(name = "ibizsample0008name")
    @ApiModelProperty(value = "ibizsample0008name", notes = "自循环流程名称")
    private String ibizSample0008Name;




    /**
     * 设置 [自循环步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }


    /**
     * 设置 [业务状态]
     */
    public void setYwState(String ywState) {
        this.ywState = ywState;
        this.modify("ywstate", ywState);
    }



    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [下一步处理人]
     */
    public void setNextPerson(String nextPerson) {
        this.nextPerson = nextPerson;
        this.modify("nextperson", nextPerson);
    }



    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [自循环流程名称]
     */
    public void setIbizSample0008Name(String ibizSample0008Name) {
        this.ibizSample0008Name = ibizSample0008Name;
        this.modify("ibizsample0008name", ibizSample0008Name);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0008id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}