package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.service.IBIZSample0011Service;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("demoapi-ibizsample0011")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0011Resource {

    @Autowired
    public IBIZSample0011Service ibizSample0011Service;

    @Autowired
    @Lazy
    public IBIZSample0011DTOMapping ibizSample0011DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单明细" },  notes = "IBIZSample0011-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-Create-all') or hasPermission(this.ibizSample0011DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0011-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s")
    public ResponseEntity<IBIZSample0011DTO> create
            (@Validated @RequestBody IBIZSample0011DTO dto) {
        IBIZSample0011 domain = ibizSample0011DtoMapping.toDomain(dto);
        ibizSample0011Service.create(domain);
        IBIZSample0011 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0011DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单明细" },  notes = "IBIZSample0011-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-Get-all') or hasPermission(this.ibizSample0011DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0011-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0011s/{ibizSample0011Id}")
    public ResponseEntity<IBIZSample0011DTO> getByIbizSample0011Id
            (@PathVariable("ibizSample0011Id") String ibizSample0011Id) {
        IBIZSample0011 rt = ibizSample0011Service.get(ibizSample0011Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0011DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单明细" },  notes = "IBIZSample0011-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-Remove-all') or hasPermission(this.ibizSample0011Service.get(#ibizSample0011Id),'DemoSys-IBIZSample0011-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0011s/{ibizSample0011Id}")
    public ResponseEntity<Boolean> removeByIbizSample0011Id
            (@PathVariable("ibizSample0011Id") String ibizSample0011Id) {
        Boolean rt = ibizSample0011Service.remove(ibizSample0011Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单明细" },  notes = "IBIZSample0011-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-Update-all') or hasPermission(this.ibizSample0011Service.get(#ibizSample0011Id),'DemoSys-IBIZSample0011-Update')")
    @VersionCheck(entity = "ibizsample0011" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0011s/{ibizSample0011Id}")
    public ResponseEntity<IBIZSample0011DTO> updateByIbizSample0011Id
            (@PathVariable("ibizSample0011Id") String ibizSample0011Id, @Validated @RequestBody IBIZSample0011DTO dto) {
        IBIZSample0011 domain = ibizSample0011DtoMapping.toDomain(dto);
        domain.setIbizSample0011Id(ibizSample0011Id);
        ibizSample0011Service.update(domain);
        IBIZSample0011 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0011DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单明细" },  notes = "IBIZSample0011-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0011DTO dto) {
        IBIZSample0011 domain = ibizSample0011DtoMapping.toDomain(dto);
        Integer rt = ibizSample0011Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单明细" },  notes = "IBIZSample0011-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0011s/getdraft")
    public ResponseEntity<IBIZSample0011DTO> getDraft
            (IBIZSample0011DTO dto) {
        IBIZSample0011 domain = ibizSample0011DtoMapping.toDomain(dto);
        IBIZSample0011 rt = ibizSample0011Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0011DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单明细" },  notes = "IBIZSample0011-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-Save-all') or hasPermission(this.ibizSample0011DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0011-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s/save")
    public ResponseEntity<IBIZSample0011DTO> save
            (@Validated @RequestBody IBIZSample0011DTO dto) {
        IBIZSample0011 domain = ibizSample0011DtoMapping.toDomain(dto);
        ibizSample0011Service.save(domain);
        IBIZSample0011 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0011DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单明细" },  notes = "IBIZSample0011-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-searchDefault-all','DemoSys-IBIZSample0011-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0011-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0011s/fetchdefault")
    public ResponseEntity<List<IBIZSample0011DTO>> fetchDefault
            (IBIZSample0011SearchContext dto) {
        Page<IBIZSample0011> domains = ibizSample0011Service.searchDefault(dto) ;
        List<IBIZSample0011DTO> list = ibizSample0011DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0011-Create-all')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0011DTO> dtos) {
        ibizSample0011Service.createBatch(ibizSample0011DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0011-Update-all')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0011s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0011DTO> dtos) {
        ibizSample0011Service.updateBatch(ibizSample0011DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0011-Save-all')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0011DTO> dtos) {
        ibizSample0011Service.saveBatch(ibizSample0011DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0011-Save-all')")
    @ApiOperation(value = "批量导入订单明细", tags = {"订单明细" },  notes = "批量导入订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0011s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0011DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0011> list=ibizSample0011DtoMapping.toDomain(dtos);
            List<IBIZSample0011> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0011Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0011-Remove-all')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0011s","/ibizsample0011s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0011Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
