package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0007;
import cn.ibizlab.core.sample.filter.IBIZSample0007SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0007Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0007Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
import cn.ibizlab.core.sample.service.IBIZSample0006Service;


/**
 * 实体[嵌套流程（子）] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0007Service")
public class IBIZSample0007ServiceBase extends ServiceImpl<IBIZSample0007Mapper,IBIZSample0007> implements IBIZSample0007Service {

    @Autowired
    @Lazy
    protected IBIZSample0006Service ibizSample0006Service;
   

    protected int batchSize = 500;

    public IBIZSample0007 get(IBIZSample0007 et) {
        IBIZSample0007 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,嵌套流程（子）:"+et.getIbizSample0007Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0007> getByEntities(List<IBIZSample0007> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0007 et) {
        if(!ObjectUtils.isEmpty(et.getIbizSample0006Id())) {
            IBIZSample0006 ibizSample0006 = et.getIbizsample0006();
            if(!ObjectUtils.isEmpty(ibizSample0006)) {
                et.setDNum(ibizSample0006.getDNum());   
                et.setDDate(ibizSample0006.getDDate());   
                et.setDText(ibizSample0006.getDText());   
                et.setIbizSample0006Name(ibizSample0006.getIbizSample0006Name());   
            }
        }    
    }

    public IBIZSample0007 getDraft(IBIZSample0007 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0007 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0007Id())) && this.count(Wrappers.<IBIZSample0007>query().eq("ibizsample0007id", et.getIbizSample0007Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0007 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0007> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0007 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0007id", et.getIbizSample0007Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0007> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0007 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0007> list) {
        List<IBIZSample0007> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0007Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0007> _create=new ArrayList<>();
        List<IBIZSample0007> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0007Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0007 et) {
        String key = et.getIbizSample0007Id();

        if(!remove(new QueryWrapper<IBIZSample0007>()
                .eq("ibizsample0007id", et.getIbizSample0007Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0007> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0007> searchCurGw(IBIZSample0007SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0007> pages=baseMapper.searchCurGw(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0007>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0007> listCurGw(IBIZSample0007SearchContext context) {
        return baseMapper.listCurGw(context,context.getSelectCond());
    }

    public Page<IBIZSample0007> searchDefault(IBIZSample0007SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0007> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0007>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0007> listDefault(IBIZSample0007SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0007> selectByIbizSample0006Id(String ibizSample0006Id) {
        return baseMapper.selectByIbizSample0006Id(ibizSample0006Id);
    }

    public boolean removeByIbizSample0006Id(String ibizSample0006Id) {
        return this.remove(new QueryWrapper<IBIZSample0007>().eq("ibizsample0006id",ibizSample0006Id));
    }

    public boolean resetByIbizSample0006Id(String ibizSample0006Id) {
        return this.update(new UpdateWrapper<IBIZSample0007>().set("ibizsample0006id",null).eq("ibizsample0006id",ibizSample0006Id));
    }

    public boolean saveByIbizsample0006(IBIZSample0006 ibizSample0006,List<IBIZSample0007> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0007> _update=new ArrayList<IBIZSample0007>();
        List<IBIZSample0007> _create=new ArrayList<IBIZSample0007>();
        for(IBIZSample0007 before:selectByIbizSample0006Id(ibizSample0006.getIbizSample0006Id())){
            delIds.add(before.getIbizSample0007Id());
        }
        for(IBIZSample0007 sub:list) {
            sub.setIbizSample0006Id(ibizSample0006.getIbizSample0006Id());
            sub.setIbizsample0006(ibizSample0006);
            if(ObjectUtils.isEmpty(sub.getIbizSample0007Id()))
                sub.setIbizSample0007Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0007Id())) {
                delIds.remove(sub.getIbizSample0007Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}