package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPVIEW;
import cn.ibizlab.core.sample.service.IBIZAPPVIEWService;
import cn.ibizlab.core.sample.filter.IBIZAPPVIEWSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"应用视图" })
@RestController("demoapi-ibizappview")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZAPPVIEWResource {

    @Autowired
    public IBIZAPPVIEWService ibizappviewService;

    @Autowired
    @Lazy
    public IBIZAPPVIEWDTOMapping ibizappviewdtoMapping;


    @ApiOperation(value = "创建Create", tags = {"应用视图" },  notes = "IBIZAPPVIEW-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-Create-all') or hasPermission(this.ibizappviewdtoMapping.toDomain(#dto),'DemoSys-IBIZAPPVIEW-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappviews")
    public ResponseEntity<IBIZAPPVIEWDTO> create
            (@Validated @RequestBody IBIZAPPVIEWDTO dto) {
        IBIZAPPVIEW domain = ibizappviewdtoMapping.toDomain(dto);
        ibizappviewService.create(domain);
        IBIZAPPVIEW rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"应用视图" },  notes = "IBIZAPPVIEW-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-Get-all') or hasPermission(this.ibizappviewdtoMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPVIEW-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappviews/{ibizappviewid}")
    public ResponseEntity<IBIZAPPVIEWDTO> getByIbizappviewid
            (@PathVariable("ibizappviewid") String ibizappviewid) {
        IBIZAPPVIEW rt = ibizappviewService.get(ibizappviewid);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"应用视图" },  notes = "IBIZAPPVIEW-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-Remove-all') or hasPermission(this.ibizappviewService.get(#ibizappviewid),'DemoSys-IBIZAPPVIEW-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizappviews/{ibizappviewid}")
    public ResponseEntity<Boolean> removeByIbizappviewid
            (@PathVariable("ibizappviewid") String ibizappviewid) {
        Boolean rt = ibizappviewService.remove(ibizappviewid);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"应用视图" },  notes = "IBIZAPPVIEW-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-Update-all') or hasPermission(this.ibizappviewService.get(#ibizappviewid),'DemoSys-IBIZAPPVIEW-Update')")
    @VersionCheck(entity = "ibizappview" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizappviews/{ibizappviewid}")
    public ResponseEntity<IBIZAPPVIEWDTO> updateByIbizappviewid
            (@PathVariable("ibizappviewid") String ibizappviewid, @Validated @RequestBody IBIZAPPVIEWDTO dto) {
        IBIZAPPVIEW domain = ibizappviewdtoMapping.toDomain(dto);
        domain.setIbizappviewid(ibizappviewid);
        ibizappviewService.update(domain);
        IBIZAPPVIEW rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"应用视图" },  notes = "IBIZAPPVIEW-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappviews/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZAPPVIEWDTO dto) {
        IBIZAPPVIEW domain = ibizappviewdtoMapping.toDomain(dto);
        Integer rt = ibizappviewService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"应用视图" },  notes = "IBIZAPPVIEW-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappviews/getdraft")
    public ResponseEntity<IBIZAPPVIEWDTO> getDraft
            (IBIZAPPVIEWDTO dto) {
        IBIZAPPVIEW domain = ibizappviewdtoMapping.toDomain(dto);
        IBIZAPPVIEW rt = ibizappviewService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"应用视图" },  notes = "IBIZAPPVIEW-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-Save-all') or hasPermission(this.ibizappviewdtoMapping.toDomain(#dto),'DemoSys-IBIZAPPVIEW-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappviews/save")
    public ResponseEntity<IBIZAPPVIEWDTO> save
            (@Validated @RequestBody IBIZAPPVIEWDTO dto) {
        IBIZAPPVIEW domain = ibizappviewdtoMapping.toDomain(dto);
        ibizappviewService.save(domain);
        IBIZAPPVIEW rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"应用视图" },  notes = "IBIZAPPVIEW-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-searchDefault-all','DemoSys-IBIZAPPVIEW-Get-all') or hasPermission(#dto,'DemoSys-IBIZAPPVIEW-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappviews/fetchdefault")
    public ResponseEntity<List<IBIZAPPVIEWDTO>> fetchDefault
            (IBIZAPPVIEWSearchContext dto) {
        Page<IBIZAPPVIEW> domains = ibizappviewService.searchDefault(dto) ;
        List<IBIZAPPVIEWDTO> list = ibizappviewdtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPVIEW-Create-all')")
    @ApiOperation(value = "批量新建应用视图", tags = {"应用视图" },  notes = "批量新建应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappviews/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPVIEWDTO> dtos) {
        ibizappviewService.createBatch(ibizappviewdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPVIEW-Update-all')")
    @ApiOperation(value = "批量更新应用视图", tags = {"应用视图" },  notes = "批量更新应用视图")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizappviews/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPVIEWDTO> dtos) {
        ibizappviewService.updateBatch(ibizappviewdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPVIEW-Save-all')")
    @ApiOperation(value = "批量保存应用视图", tags = {"应用视图" },  notes = "批量保存应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappviews/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPVIEWDTO> dtos) {
        ibizappviewService.saveBatch(ibizappviewdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPVIEW-Save-all')")
    @ApiOperation(value = "批量导入应用视图", tags = {"应用视图" },  notes = "批量导入应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappviews/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZAPPVIEWDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZAPPVIEW> list=ibizappviewdtoMapping.toDomain(dtos);
            List<IBIZAPPVIEW> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizappviewService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPVIEW-Remove-all')")
    @ApiOperation(value = "批量删除应用视图", tags = {"应用视图" },  notes = "批量删除应用视图")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizappviews","/ibizappviews/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappviewService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
