package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0012DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZSample0012DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 订单标识
     */
    @JsonProperty("ibizsample0012id")
    @JSONField(name = "ibizsample0012id")
    @ApiModelProperty("订单标识")
    private String ibizSample0012Id;

    /**
     * 订单名称
     */
    @JsonProperty("ibizsample0012name")
    @JSONField(name = "ibizsample0012name")
    @ApiModelProperty("订单名称")
    private String ibizSample0012Name;

    /**
     * 备注
     */
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 订单时间
     */
    @JsonProperty("ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间")
    private Timestamp orderTime;

    /**
     * 订单类型
     */
    @JsonProperty("ordertype")
    @JSONField(name = "ordertype")
    @ApiModelProperty("订单类型")
    private String orderType;

    /**
     * 订单编号
     */
    @JsonProperty("orderuid")
    @JSONField(name = "orderuid")
    @ApiModelProperty("订单编号")
    private String orderUid;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [订单名称]
     */
    public void setIbizSample0012Name(String ibizSample0012Name) {
        this.ibizSample0012Name = ibizSample0012Name;
        this.modify("ibizsample0012name", ibizSample0012Name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrderTime(Timestamp orderTime) {
        this.orderTime = orderTime;
        this.modify("ordertime", orderTime);
    }

    /**
     * 设置 [订单类型]
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
        this.modify("ordertype", orderType);
    }

    /**
     * 设置 [订单编号]
     */
    public void setOrderUid(String orderUid) {
        this.orderUid = orderUid;
        this.modify("orderuid", orderUid);
    }


}
