package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0014DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("员工")
public class IBIZSample0014DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * IBIZSAMPLE0003标识
     */
    @JsonProperty("ibizsample0003id")
    @JSONField(name = "ibizsample0003id")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String ibizsample0003Id;

    /**
     * 名称
     */
    @JsonProperty("ibizsample0003name")
    @JSONField(name = "ibizsample0003name")
    @ApiModelProperty("名称")
    private String ibizsample0003Name;

    /**
     * 员工标识
     */
    @JsonProperty("ibizsample0014id")
    @JSONField(name = "ibizsample0014id")
    @ApiModelProperty("员工标识")
    private String ibizSample0014Id;

    /**
     * 员工名称
     */
    @JsonProperty("ibizsample0014name")
    @JSONField(name = "ibizsample0014name")
    @ApiModelProperty("员工名称")
    private String ibizSample0014Name;

    /**
     * 员工编号
     */
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty("员工编号")
    private String sn;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setIbizsample0003Id(String ibizsample0003Id) {
        this.ibizsample0003Id = ibizsample0003Id;
        this.modify("ibizsample0003id", ibizsample0003Id);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizsample0003Name(String ibizsample0003Name) {
        this.ibizsample0003Name = ibizsample0003Name;
        this.modify("ibizsample0003name", ibizsample0003Name);
    }

    /**
     * 设置 [员工名称]
     */
    public void setIbizSample0014Name(String ibizSample0014Name) {
        this.ibizSample0014Name = ibizSample0014Name;
        this.modify("ibizsample0014name", ibizSample0014Name);
    }

    /**
     * 设置 [员工编号]
     */
    public void setSn(String sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }


}
