import { Http,Util } from '@/utils';
import PrintParamsUILogicBase from './print-params-ui-logic-base';

/**
 * 输出参数
 *
 * @export
 * @class PrintParamsUILogic
 */
export default class PrintParamsUILogic extends PrintParamsUILogicBase {

    /**
     * 输出参数 逻辑实例对象
     *
     * @private
     * @static
     * @type {PrintParamsUILogic}
     * @memberof PrintParamsUILogic
     */
    private static instance: PrintParamsUILogic;

    /**
     * 获取 输出参数 逻辑实例对象
     *
     * @static
     * @return {*}  {PrintParamsUILogic}
     * @memberof PrintParamsUILogic
     */
    static getInstance(): PrintParamsUILogic {
        if (!this.instance) {
            this.instance = new PrintParamsUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  PrintParamsUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  PrintParamsUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}