import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
/**
 * 表格加载
 *
 * @export
 * @class GridLoadUILogicBase
 */
export default class GridLoadUILogicBase {

    /**
     * Creates an instance of  GridLoadBase.
     * 
     * @param {*} [opts={}]
     * @memberof GridLoadUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof GridLoadUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '当前视图',
            codeName: 'view',
            activeViewParam: true,
        },
        {
            name: '额外参数',
            codeName: 'otherParam',
            entityParam: true,
        },
        {
            name: '当前视图参数',
            codeName: 'viewParam',
            viewNavDataParam: true,
        },
        {
            name: '当前表格',
            codeName: 'grid',
            ctrlParam: true,
        },
        {
            name: '当前搜索表单',
            codeName: 'searchForm',
            ctrlParam: true,
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof GridLoadUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof GridLoadUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        //  表格加载
        actionContext.setResult(actionContext.defaultParam.getReal());
        console.log('已完成执行 开始 节点');
        await this.execute_bindparam1_node(actionContext);
    }
    
    /**
     * 实体行为
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_deaction1_node(actionContext: UIActionContext) {
        //  表格加载
        const dstParam = actionContext.getParam('otherParam');
        if (!Object.is(dstParam.logicParamType, UILogicParamType.entityListParam) && !Object.is(dstParam.logicParamType, UILogicParamType.entityParam)) {
            throw new Error(`实体行为操作参数只能为数据对象变量类型或者数据对象列表类型`);
        }
        const retParam = actionContext.getParam('Default');
        if (dstParam) {
            try {
                const service: IBIZBOOKService =  = new IBIZBOOKService;
                const getTempContext = (data: any) => {
                    const tempContext = Util.deepCopy(actionContext.context);
                    if (data) {
                        Object.assign(tempContext, data);
                    }
                    return tempContext;
                }
                // 数据对象变量类型
                if (Object.is(dstParam.logicParamType, UILogicParamType.entityParam)) {
                    const tempContext = getTempContext(dstParam.getReal());
                    const res = await service['Get'](tempContext, dstParam.getReal() ? dstParam.getReal() : {});
                    if (res && res.ok && res.data) {
                        if (retParam) {
                            retParam.bind(res.data);
                        }
                        actionContext.bindLastReturnParam(res.data);
                    } else {
                        throw new Error(`执行实体行为失败`);
                    }
                } else {
                    // 数据对象列表类型
                    if (dstParam.getReal() && (dstParam.getReal().length > 0)) {
                        if (dstParam.getReal().length > 20) {
                            throw new Error(`操作数据量超过20条，建议使用后台处理逻辑`);
                        }
                        let promises: any[] = [];
                        dstParam.getReal().forEach((item: any) => {
                            const tempContext = getTempContext(item);
                            promises.push(service['Get'](tempContext, item ? item : {}));
                        })
                        const resArray = await Promise.all(promises);
                        if (resArray && resArray.length > 0) {
                            const resultArray: any[] = [];
                            resArray.forEach((res: any) => {
                                if (res && res.ok && res.data) {
                                    resultArray.push(res.data);
                                }
                            })
                            if (retParam) {
                                retParam.bind(resultArray);
                            }
                            actionContext.bindLastReturnParam(resultArray);
                        } else {
                            throw new Error(`执行实体行为失败`);
                        }
                    } else {
                        if (retParam) {
                            retParam.bind([]);
                        }
                        actionContext.bindLastReturnParam([]);
                    }
                }
            } catch (error: any) {
                throw new Error(`${error.message ? error.message : error.data && error.data.message ? error.data.message : '执行实体行为失败'}`);
            }
        } else {
            throw new Error(`操作参数缺失！`);
        }
        console.log('已完成执行 实体行为 节点');
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 准备参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_preparejsparam1_node(actionContext: UIActionContext) {
        //  表格加载
        try {
            //  目标数据
            const dstParam_1: any = actionContext.getParam('otherParam');
            //  无值类型
                            //  直接值
            const result_1 = '12';
            const dstParam_1.set('book', result_1);
        } catch (error: any) {
            throw new Error(`逻辑节点 准备参数 ${error ## error.message ? error.message : '发生未知错误！'}`);
        }
        console.log('已完成执行 准备参数 节点');
        await this.execute_deaction1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        //  表格加载
        const strReturnType: string = 'LOGICPARAM';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('Default');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
        console.log('已完成执行 结束 节点');
    }
    
    /**
     * 绑定搜索表单
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_bindparam1_node(actionContext: UIActionContext) {
        //  表格加载
        try {
            //  源数据
            const srcParam = actionContext.getParam('view');
            //  目标数据
            const dstParam = actionContext.getParam('searchForm');
            //  源属性
            const srcFieldName: string = 'searchform';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数当前搜索表单 ${error && error.message ? error.message : '发生未知错误!'}`);
        }
        console.log('已完成执行 绑定搜索表单 节点');
        await this.execute_bindparam2_node(actionContext);
    }
    
    /**
     * 搜索表单loadDraft
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_viewctrlinvoke1_node(actionContext: UIActionContext) {
        //  表格加载
        const invokeCtrl = 'searchForm';
        const invokeMethod = 'loadDraft';
        const invokeParam = 'viewParam';
        if (!invokeCtrl || !invokeMethod) {
            throw new Error(`界面对象或者调用方法缺失`);
        }
        const invokeUICtrl = actionContext.getParam(invokeCtrl).getReal();
        if (invokeUICtrl[invokeMethod] && invokeUICtrl[invokeMethod] instanceof Function) {
            try {
                const result = await invokeUICtrl[invokeMethod]();
                if (invokeParam) {
                    actionContext.getParam(invokeParam).bind(result);
                }
                actionContext.bindLastReturnParam(result);
            } catch (error:any) {
                throw new Error(`${invokeCtrl}界面对象调用${invokeMethod}方法发生异常`);
            }
        } else {
            throw new Error(`${invokeCtrl}界面对象不存在${invokeMethod}方法`);
        }
        console.log('已完成执行 搜索表单loadDraft 节点');
        await this.execute_viewctrlinvoke2_node(actionContext);
    }
    
    /**
     * 消息弹窗
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_msgbox1_node(actionContext: UIActionContext) {
        //  表格加载
        //  TODO 等待补充
        return new Promise<void>((resolve: any) => {
            const msgBoxParam: any = actionContext.getParam('');
            const data = msgBoxParam ? msgBoxParam.getReal() : {};
            const options = {
                type: 'INFO',
                title: data && data.title ? data.title : '触发',
                content: data && data.message ? data.message : '我被触发啦',
                buttonType: 'ok',
                showMode: 'center',
                showClose: false,
                mask: true,
                maskClosable: true
            };
            //  TODO 支持具体弹窗
            //  const subject: Subject<any> | null = AppMessageBoxService.getInstance().open(options);
            //  const subscription = subject?.subscribe((result: any) => {
            //      resolve(this.handleResponse(logicNode, actionContext, options, result));
            //      subscription!.unsubscribe();
            //      subject.complete();
            //  })
        });
        console.log('已完成执行 消息弹窗 节点');
    }
    
    /**
     * 实体处理逻辑
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_delogic1_node(actionContext: UIActionContext) {
        //  表格加载
        const dstParam = actionContext.getParam('searchForm');
        const retParam = actionContext.getParam('searchForm');
        if (dstParam) {
            try {
                const service: IBIZBOOKService =  = new IBIZBOOKService;
                const result = await service['executeAppDELogic']('print', actionContext.context, dstParam.getReal() ? dstParam.getReal() : {});
                if (result) {
                    if(retParam){
                        retParam.bind(result);
                    }
                    actionContext.bindLastReturnParam(result);
                    return retParam;
                } else {
                    throw new Error(`调用实体处理逻辑异常`);
                }
            } catch (error: any) {
                throw new Error(`调用实体处理逻辑异常${error && error.message ? error.message : ''}`);
            }
        } else {
            throw new Error(`操作参数缺失！`);
        }
        console.log('已完成执行 实体处理逻辑 节点');
        await this.execute_msgbox1_node(actionContext);
        await this.execute_preparejsparam1_node(actionContext);
    }
    
    /**
     * 表格加载
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_viewctrlinvoke2_node(actionContext: UIActionContext) {
        //  表格加载
        const invokeCtrl = 'grid';
        const invokeMethod = 'load';
        const invokeParam = 'viewParam';
        if (!invokeCtrl || !invokeMethod) {
            throw new Error(`界面对象或者调用方法缺失`);
        }
        const invokeUICtrl = actionContext.getParam(invokeCtrl).getReal();
        if (invokeUICtrl[invokeMethod] && invokeUICtrl[invokeMethod] instanceof Function) {
            try {
                const result = await invokeUICtrl[invokeMethod]();
                if (invokeParam) {
                    actionContext.getParam(invokeParam).bind(result);
                }
                actionContext.bindLastReturnParam(result);
            } catch (error:any) {
                throw new Error(`${invokeCtrl}界面对象调用${invokeMethod}方法发生异常`);
            }
        } else {
            throw new Error(`${invokeCtrl}界面对象不存在${invokeMethod}方法`);
        }
        console.log('已完成执行 表格加载 节点');
        await this.execute_delogic1_node(actionContext);
    }
    
    /**
     * 绑定表格
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof GridLoadUILogicBase
     */
    protected async execute_bindparam2_node(actionContext: UIActionContext) {
        //  表格加载
        try {
            //  源数据
            const srcParam = actionContext.getParam('view');
            //  目标数据
            const dstParam = actionContext.getParam('grid');
            //  源属性
            const srcFieldName: string = 'grid';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数当前表格 ${error && error.message ? error.message : '发生未知错误!'}`);
        }
        console.log('已完成执行 绑定表格 节点');
        await this.execute_viewctrlinvoke1_node(actionContext);
    }
    

}