import ViewMessageService from '../view-message-service';
/**
 * 饼图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg79MessageServiceBase
 */
export default class ViewMsg79MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg79MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg79MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg79MessageServiceBase
     */
    public initBasicParam(){
        this.id = "556DAAC8-8D91-4827-A6AC-E14400598587";
        this.name = "饼图";
        this.codename = "ViewMsg79";
        this.title = "";
        this.content = "本示例展示订单审核状态饼图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg79MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}