import ViewMessageService from '../view-message-service';
/**
 * 甘特图视图消息服务对象基类
 *
 * @export
 * @class ViewMsg72MessageServiceBase
 */
export default class ViewMsg72MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg72MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg72MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg72MessageServiceBase
     */
    public initBasicParam(){
        this.id = "E76F01C4-4F91-4E37-885E-B7080B62E5DA";
        this.name = "甘特图";
        this.codename = "ViewMsg72";
        this.title = "";
        this.content = "本示例展示甘特图基本功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg72MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}