import ViewMessageService from '../view-message-service';
/**
 * 表格---值重置视图消息服务对象基类
 *
 * @export
 * @class ViewMsg42MessageServiceBase
 */
export default class ViewMsg42MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg42MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg42MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg42MessageServiceBase
     */
    public initBasicParam(){
        this.id = "FD990050-8564-4649-99B1-96E5BBC69158";
        this.name = "表格---值重置";
        this.codename = "ViewMsg42";
        this.title = "";
        this.content = "本示例展示表格的值重置功能；借出日期值变化会重置归还日期表格列值。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg42MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}