import ViewMessageService from '../view-message-service';
/**
 * 多表单编辑（上分页）视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg34MessageServiceBase
 */
export default class ViewMsg34MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg34MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg34MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg34MessageServiceBase
     */
    public initBasicParam(){
        this.id = "dc364e6c9d8173f67bf68b2755ae59dd";
        this.name = "多表单编辑（上分页）";
        this.codename = "ViewMsg34";
        this.title = "";
        this.content = "本示例展示多表单编辑的上分页样式：该视图为图书多表单编辑视图上分页样式。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg34MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}