import { ILogicNode } from '@/interface/logic';
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from './logic-node-base';
/**
 * 排序数组参数节点
 *
 * @export
 * @class UILogicSortParamNode
 */
export class UILogicSortParamNode extends UILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof UILogicSortParamNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.onSortParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 排序数组变量
     *
     * @param {ILogicNode} logicNodeParam
     * @param {UIActionContext} actionContext
     * @memberof UILogicPrepareParamNode
     */
     public onSortParam(logicNodeParam: ILogicNode, actionContext: UIActionContext) {
        // // 目标数据
        // const dstParam: any = actionContext.getParam((logicNodeParam.getDstPSDEUILogicParam() as IPSDEUILogicParam)?.codeName);
        // // 目标属性
        // const dstFieldName: string = logicNodeParam.dstFieldName?.toLowerCase?.();
        // if (!dstFieldName) {
        //     throw new Error(`逻辑参数${logicNodeParam.name}未指定设置排序属性`);
        // }
        // dstParam.sort(dstFieldName, logicNodeParam.dstSortDir);
        // actionContext.bindLastReturnParam(null);
    }
}