import { ILogicNode } from '@/interface/logic';
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from './logic-node-base';
/**
 * 前端扩展插件调用节点
 *
 * @export
 * @class UILogicPluginNode
 */
export class UILogicPluginNode extends UILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof UILogicPluginNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        throw new Error(`逻辑节点${logicNode.name}前端扩展插件类型暂未实现！`);
    }
}