import { ILogicNode } from "@/interface/logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UIActionContext } from "../uiaction-context";
import { UILogicNodeBase } from "./logic-node-base";

/**
 * 结束节点
 *
 * @export
 * @class EndNode
 */
export class UILogicEndNode extends UILogicNodeBase {
    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @return {*} 
     * @memberof EndNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.handleEndNode(logicNode, actionContext);
            console.log(`已完成执行${logicNode?.name}节点，操作参数数据如下:`);
            if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
                for (let [key, value] of actionContext.paramsMap) {
                    console.log(`${key}:`, value.getReal());
                }
            }
            return { nextNodes: [], actionContext };
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处理结束节点
     *
     * @private
     * @param {IPSDEEndLogic} logicNode
     * @param {UIActionContext} actionContext
     * @memberof EndNode
     */
    private handleEndNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        const strReturnType: string = logicNode.returnType as string;
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult(logicNode.returnRawValue);
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam(logicNode.returnParam as string);
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(logicNode.dstFieldName));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
    }
}