import { ILogicNode } from "@/interface/logic";
import { UIActionContext } from "../uiaction-context";
import { UILogicNodeBase } from "./logic-node-base";

export class UILogicBindParamNode extends UILogicNodeBase {
    /**
     * 执行节点
     *
     * @param {IPSDEUIBindParamLogic} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof AppUILogicBindParamNode
     */
     public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.onBindParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error?.message ? error?.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处理参数
     *
     * @param {IPSDEUIBindParamLogic} logicNode 节点模型数据
     * @param {UIActionContext} actionContext  逻辑上下文
     * @memberof AppUILogicBindParamNode
     */
    public onBindParam(logicNode: ILogicNode, actionContext: UIActionContext) {
        if (!logicNode || !logicNode.dstParam || !logicNode.srcParam) {
            throw new Error(`操作参数或者源参数缺失！`);
        }
        try {
            // 源数据
            const srcParam: any = actionContext.getParam(logicNode.srcParam);
            // 目标数据
            const dstParam: any = actionContext.getParam(logicNode.dstParam);
            // 源属性
            const srcFieldName: string = logicNode.srcFieldName ? logicNode.srcFieldName.toLowerCase() : '';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数${logicNode.dstParam}${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }
}