import { ILogicNode } from '@/interface/logic';
import { UIActionContext } from '../uiaction-context';
import { UILogicNodeBase } from './logic-node-base';
/**
 * 重新建立参数节点
 *
 * @export
 * @class UILogicReNewParamNode
 */
export class UILogicReNewParamNode extends UILogicNodeBase {

    constructor() {
        super();
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode 逻辑节点模型数据
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof UILogicReNewParamNode
     */
    public async executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            this.onRenewParam(logicNode, actionContext);
            return this.computeNextNodes(logicNode, actionContext);
        } catch (error: any) {
            throw new Error(`逻辑节点 ${logicNode.name}${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 处理参数
     *
     * @param {ILogicNode} logicNode 节点模型数据
     * @param {UIActionContext} actionContext  逻辑上下文
     * @memberof UILogicReNewParamNode
     */
    public onRenewParam(logicNode: ILogicNode, actionContext: UIActionContext) {
        // if (!logicNode || !logicNode.getDstPSDEUILogicParam()) {
        //     throw new Error(`操作参数缺失！`);
        // }
        // try {
        //     // 目标数据
        //     const dstParam: any = actionContext.getParam((logicNode.getDstPSDEUILogicParam() as IPSDEUILogicParam)?.codeName);
        //     dstParam.renew();
        //     actionContext.bindLastReturnParam(null);
        // } catch (error: any) {
        //     throw new Error(`逻辑参数${logicNode.getDstPSDEUILogicParam()?.name}${error && error.message ? error.message : '发生未知错误！'}`);
        // }
    }
}