import { ILogicNode } from "@/interface/logic";
import { Util, Verify } from "@/utils";
import { UIActionContext } from "../uiaction-context";

/**
 * 处理逻辑节点基类
 *
 * @export
 * @class UILogicNodeBase
 */
export class UILogicNodeBase {

    constructor() {}

    /**
     * 根据处理链接计算后续逻辑节点
     *
     * @param {*} logicNode
     * @param {UIActionContext} actionContext
     * @return {*} 
     * @memberof LogicNodeBase
     */
    public computeNextNodes(logicNode: ILogicNode, actionContext: UIActionContext) {
        console.log(`已完成执行${logicNode?.name}节点，操作参数数据如下:`)
        if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
            for (let [key, value] of actionContext.paramsMap) {
                console.log(`${key}:`, Util.deepCopy(value.getReal()));
            }
        }
        let result: any = { nextNodes: [], actionContext };
        if (logicNode && logicNode.logicLinks && logicNode.logicLinks.length > 0) {
            for (let logicLink of logicNode.logicLinks) {
                let nextNode = logicLink.dstLogicNode;
                // 没有连接条件组或有条件组且满足条件组时执行下一个节点
                if (!logicLink.dstLogicNode || this.computeCond(logicLink.linkGroupCond || [], actionContext)) {
                    // console.log(`即将执行${nextNode?}节点`);
                    console.log('执行下一节点');
                    result.nextNodes.push(nextNode);
                }
            }
        }
        return result;
    }

    /**
     * 计算是否通过逻辑连接
     *
     * @param {} logicLinkCond
     * @return {*} 
     * @memberof UILogicNodeBase
     */
    public computeCond(logicLinkCond: any, actionContext: UIActionContext): any {
        if (logicLinkCond.logicType == 'GROUP') {
            const logicLinkGroupCond = logicLinkCond
            const childConds: any = logicLinkGroupCond.getPSDELogicLinkConds();
            if (childConds?.length > 0) {
                // return Verify.logicForEach(
                //     childConds,
                //     (item: any) => {
                //         return this.computeCond(item, actionContext);
                //     },
                //     logicLinkGroupCond.groupOP,
                //     !!logicLinkGroupCond.notMode,
                // );
            }
        } else {
            if (logicLinkCond.logicType == 'SINGLE') {
                const logicLinkSingleCond = logicLinkCond
                let dstValue = actionContext.getParam(logicLinkSingleCond?.getDstLogicParam?.()?.codeName as string);
                if (logicLinkSingleCond.dstFieldName) {
                    dstValue = dstValue.get(logicLinkSingleCond.dstFieldName.toLowerCase());
                }
                let targetValue;
                if (logicLinkSingleCond.paramType) {
                    switch (logicLinkSingleCond.paramType) {
                        case 'CURTIME':
                            targetValue = Util.dateFormat(new Date(), 'YYYY-MM-DD');
                            break;
                        default:
                            targetValue = logicLinkSingleCond.paramValue;
                    }
                } else {
                    targetValue = logicLinkSingleCond.paramValue;
                }
                return Verify.testCond(dstValue, logicLinkSingleCond.condOP, targetValue)
            }
        }
    }

}