package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
import cn.ibizlab.core.sample.filter.IBIZTASKTEAMSearchContext;
import cn.ibizlab.core.sample.service.IBIZTASKTEAMService;
import cn.ibizlab.core.sample.mapper.IBIZTASKTEAMMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZTASK;
import cn.ibizlab.core.sample.service.IBIZTASKService;


/**
 * 实体[任务团队] 服务对象接口实现
 */
@Slf4j
@Service("IBIZTASKTEAMService")
public class IBIZTASKTEAMServiceBase extends ServiceImpl<IBIZTASKTEAMMapper,IBIZTASKTEAM> implements IBIZTASKTEAMService {

    @Autowired
    @Lazy
    protected IBIZTASKService ibiztaskService;
   

    protected int batchSize = 500;

    public IBIZTASKTEAM get(IBIZTASKTEAM et) {
        IBIZTASKTEAM rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,任务团队:"+et.getIbiztaskteamid());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZTASKTEAM> getByEntities(List<IBIZTASKTEAM> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZTASKTEAM et) {
    }

    public IBIZTASKTEAM getDraft(IBIZTASKTEAM et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZTASKTEAM et) {
        return ( (!ObjectUtils.isEmpty(et.getIbiztaskteamid())) && this.count(Wrappers.<IBIZTASKTEAM>query().eq("ibiztaskteamid", et.getIbiztaskteamid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZTASKTEAM et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZTASKTEAM> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZTASKTEAM et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibiztaskteamid", et.getIbiztaskteamid());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZTASKTEAM> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZTASKTEAM et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZTASKTEAM> list) {
        List<IBIZTASKTEAM> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbiztaskteamid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZTASKTEAM> _create=new ArrayList<>();
        List<IBIZTASKTEAM> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbiztaskteamid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZTASKTEAM et) {
        String key = et.getIbiztaskteamid();

        if(!remove(new QueryWrapper<IBIZTASKTEAM>()
                .eq("ibiztaskteamid", et.getIbiztaskteamid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZTASKTEAM> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    @Transactional
    public IBIZTASKTEAM createTemp(IBIZTASKTEAM dto) {
        return dto;
    }

    @Transactional
    public IBIZTASKTEAM createTempMajor(IBIZTASKTEAM dto) {
        return dto;
    }

    @Transactional
    public IBIZTASKTEAM updateTemp(IBIZTASKTEAM dto) {
        return dto;
    }

    @Transactional
    public IBIZTASKTEAM updateTempMajor(IBIZTASKTEAM dto) {
        return dto;
    }

    @Transactional
    public List<String> removeTemp(List<String> keys) {
        return keys;
    }

    @Transactional
    public List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    @Transactional
    public IBIZTASKTEAM getTemp(String key) {
        return null;
    }

    @Transactional
    public IBIZTASKTEAM getTempMajor(String key) {
        return null;
    }

    @Transactional
    public IBIZTASKTEAM getDraftTemp(IBIZTASKTEAM dto) {
        return null;
    }

    @Transactional
    public IBIZTASKTEAM getDraftTempMajor(IBIZTASKTEAM dto) {
        return null;
    }

    public Page<IBIZTASKTEAM> searchDefault(IBIZTASKTEAMSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZTASKTEAM> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZTASKTEAM>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZTASKTEAM> listDefault(IBIZTASKTEAMSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZTASKTEAM> selectByRoot(String root) {
        return baseMapper.selectByRoot(root);
    }

    public boolean removeByRoot(String root) {
        return this.remove(new QueryWrapper<IBIZTASKTEAM>().eq("root",root));
    }

    public boolean resetByRoot(String root) {
        return this.update(new UpdateWrapper<IBIZTASKTEAM>().set("root",null).eq("root",root));
    }

    public boolean saveByTaskTeam(IBIZTASK ibiztask,List<IBIZTASKTEAM> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZTASKTEAM> _update=new ArrayList<IBIZTASKTEAM>();
        List<IBIZTASKTEAM> _create=new ArrayList<IBIZTASKTEAM>();
        for(IBIZTASKTEAM before:selectByRoot(ibiztask.getIbiztaskid())){
            delIds.add(before.getIbiztaskteamid());
        }
        for(IBIZTASKTEAM sub:list) {
            sub.setRoot(ibiztask.getIbiztaskid());
            sub.setTaskTeam(ibiztask);
            if(ObjectUtils.isEmpty(sub.getIbiztaskteamid()))
                sub.setIbiztaskteamid((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbiztaskteamid())) {
                delIds.remove(sub.getIbiztaskteamid());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }





    }