package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample;
import cn.ibizlab.core.sample.filter.IBIZSampleSearchContext;
import cn.ibizlab.core.sample.service.IBIZSampleService;
import cn.ibizlab.core.sample.mapper.IBIZSampleMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[示例数据库] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSampleService")
public class IBIZSampleServiceBase extends ServiceImpl<IBIZSampleMapper,IBIZSample> implements IBIZSampleService {


    protected int batchSize = 500;

    public IBIZSample get(IBIZSample et) {
        IBIZSample rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,示例数据库:"+et.getIbizSampleId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample> getByEntities(List<IBIZSample> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZSample getDraft(IBIZSample et) {
        return et;
    }

    public Integer checkKey(IBIZSample et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSampleId())) && this.count(Wrappers.<IBIZSample>query().eq("ibizsampleid", et.getIbizSampleId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsampleid", et.getIbizSampleId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample> list) {
        List<IBIZSample> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSampleId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample> _create=new ArrayList<>();
        List<IBIZSample> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSampleId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample et) {
        String key = et.getIbizSampleId();

        if(!remove(new QueryWrapper<IBIZSample>()
                .eq("ibizsampleid", et.getIbizSampleId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample> searchDefault(IBIZSampleSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample> listDefault(IBIZSampleSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }