package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.filter.IBIZHardwareSearchContext;
import cn.ibizlab.core.sample.service.IBIZHardwareService;
import cn.ibizlab.core.sample.mapper.IBIZHardwareMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.service.IBIZUNIProductService;


/**
 * 实体[硬件] 服务对象接口实现
 */
@Slf4j
@Service("IBIZHardwareService")
public class IBIZHardwareServiceBase extends ServiceImpl<IBIZHardwareMapper,IBIZHardware> implements IBIZHardwareService {

    @Autowired
    @Lazy
    protected IBIZUNIProductService ibizuniProductService;
   
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.mapping.IBIZHardwareInheritMapping ibizHardwareInheritMapping;

    protected int batchSize = 500;

    public IBIZHardware get(IBIZHardware et) {
        IBIZHardware rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,硬件:"+et.getIbizHardwareId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZHardware> getByEntities(List<IBIZHardware> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZHardware getDraft(IBIZHardware et) {
        return et;
    }

    public Integer checkKey(IBIZHardware et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizHardwareId())) && this.count(Wrappers.<IBIZHardware>query().eq("ibizhardwareid", et.getIbizHardwareId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZHardware et) {
        if(ObjectUtils.isEmpty(et.getIbizHardwareId()))
            et.setIbizHardwareId((String)et.getDefaultKey(true));
        IBIZUNIProduct ibizuniProduct = ibizHardwareInheritMapping.toIbizuniProduct(et);
        ibizuniProductService.create(ibizuniProduct);

        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZHardware> list) {
        for (IBIZHardware et : list) {
            getSelf().create(et);
        }
        return true;
    }

    @Transactional
    public boolean update(IBIZHardware et) {
        IBIZUNIProduct ibizuniProduct = ibizHardwareInheritMapping.toIbizuniProduct(et);
        ibizuniProductService.save(ibizuniProduct);

        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizhardwareid", et.getIbizHardwareId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZHardware> list) {
        for (IBIZHardware et : list) {
            getSelf().update(et);
        }
        return true;
    }

    @Transactional
    public boolean save(IBIZHardware et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZHardware> list) {
        List<IBIZHardware> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizHardwareId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZHardware> _create=new ArrayList<>();
        List<IBIZHardware> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizHardwareId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZHardware et) {
        String key = et.getIbizHardwareId();
        ibizuniProductService.remove(ibizHardwareInheritMapping.toIbizuniProduct(et));


        if(!remove(new QueryWrapper<IBIZHardware>()
                .eq("ibizhardwareid", et.getIbizHardwareId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZHardware> entities) {
        for (IBIZHardware et : entities) {
            if(!getSelf().remove(et))
                return false;
        }
        return true;
    }

    public Page<IBIZHardware> searchDefault(IBIZHardwareSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZHardware> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZHardware>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZHardware> listDefault(IBIZHardwareSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }