package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCustomerMG;
import cn.ibizlab.core.sample.filter.IBIZCustomerMGSearchContext;
import cn.ibizlab.core.sample.service.IBIZCustomerMGService;
import cn.ibizlab.core.sample.mapper.IBIZCustomerMGMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZCustomer;
import cn.ibizlab.core.sample.service.IBIZCustomerService;


/**
 * 实体[客户管理] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCustomerMGService")
public class IBIZCustomerMGServiceBase extends ServiceImpl<IBIZCustomerMGMapper,IBIZCustomerMG> implements IBIZCustomerMGService {

    @Autowired
    @Lazy
    protected IBIZCustomerService ibizCustomerService;
   
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.mapping.IBIZCustomerMGInheritMapping ibizCustomerMgInheritMapping;

    protected int batchSize = 500;

    public IBIZCustomerMG get(IBIZCustomerMG et) {
        IBIZCustomerMG rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,客户管理:"+et.getIbizCustomerId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZCustomerMG> getByEntities(List<IBIZCustomerMG> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZCustomerMG getDraft(IBIZCustomerMG et) {
        return et;
    }

    public Integer checkKey(IBIZCustomerMG et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizCustomerId())) && this.count(Wrappers.<IBIZCustomerMG>query())>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZCustomerMG et) {
        if(ObjectUtils.isEmpty(et.getIbizCustomerId()))
            et.setIbizCustomerId((String)et.getDefaultKey(true));
        IBIZCustomer ibizCustomer = ibizCustomerMgInheritMapping.toIbizCustomer(et);
        ibizCustomerService.create(ibizCustomer);

        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZCustomerMG> list) {
        for (IBIZCustomerMG et : list) {
            getSelf().create(et);
        }
        return true;
    }

    @Transactional
    public boolean update(IBIZCustomerMG et) {
        IBIZCustomer ibizCustomer = ibizCustomerMgInheritMapping.toIbizCustomer(et);
        ibizCustomerService.save(ibizCustomer);

        UpdateWrapper qw=et.getUpdateWrapper(true);
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZCustomerMG> list) {
        for (IBIZCustomerMG et : list) {
            getSelf().update(et);
        }
        return true;
    }

    @Transactional
    public boolean save(IBIZCustomerMG et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZCustomerMG> list) {
        List<IBIZCustomerMG> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizCustomerId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZCustomerMG> _create=new ArrayList<>();
        List<IBIZCustomerMG> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizCustomerId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZCustomerMG et) {
        String key = et.getIbizCustomerId();
        ibizCustomerService.remove(ibizCustomerMgInheritMapping.toIbizCustomer(et));


        if(!remove(new QueryWrapper<IBIZCustomerMG>()
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZCustomerMG> entities) {
        for (IBIZCustomerMG et : entities) {
            if(!getSelf().remove(et))
                return false;
        }
        return true;
    }

    public Page<IBIZCustomerMG> searchDefault(IBIZCustomerMGSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustomerMG> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustomerMG>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZCustomerMG> listDefault(IBIZCustomerMGSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }