package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCustom;
import cn.ibizlab.core.sample.filter.IBIZCustomSearchContext;
import cn.ibizlab.core.sample.service.IBIZCustomService;
import cn.ibizlab.core.sample.mapper.IBIZCustomMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[自定义] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCustomService")
public class IBIZCustomServiceBase extends ServiceImpl<IBIZCustomMapper,IBIZCustom> implements IBIZCustomService {


    protected int batchSize = 500;

    public IBIZCustom get(IBIZCustom et) {
        IBIZCustom rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,自定义:"+et.getIbizCustomId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZCustom> getByEntities(List<IBIZCustom> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZCustom getDraft(IBIZCustom et) {
        return et;
    }

    public Integer checkKey(IBIZCustom et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizCustomId())) && this.count(Wrappers.<IBIZCustom>query().eq("ibizcustomid", et.getIbizCustomId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZCustom et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZCustom> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZCustom et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizcustomid", et.getIbizCustomId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZCustom> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZCustom et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZCustom> list) {
        List<IBIZCustom> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizCustomId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZCustom> _create=new ArrayList<>();
        List<IBIZCustom> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizCustomId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZCustom et) {
        String key = et.getIbizCustomId();

        if(!remove(new QueryWrapper<IBIZCustom>()
                .eq("ibizcustomid", et.getIbizCustomId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZCustom> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZCustom> searchDefault(IBIZCustomSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustom> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustom>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZCustom> listDefault(IBIZCustomSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }