package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZViewMsg;
import cn.ibizlab.core.sample.filter.IBIZViewMsgSearchContext;

public interface IBIZViewMsgService extends IService<IBIZViewMsg> {

    default IBIZViewMsgService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZViewMsg get(IBIZViewMsg et);
    default IBIZViewMsg get(String key) {
        IBIZViewMsg et = new IBIZViewMsg();
        et.setIbizViewMsgId(key);
        return getSelf().get(et);
    }
    default List<IBIZViewMsg> getByIds(Collection<String> ids) {
        List<IBIZViewMsg> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZViewMsg et = new IBIZViewMsg();
            et.setIbizViewMsgId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZViewMsg> getByEntities(List<IBIZViewMsg> entities);

    IBIZViewMsg getDraft(IBIZViewMsg et);

    Integer checkKey(IBIZViewMsg et);

    boolean create(IBIZViewMsg et);
    boolean createBatch(List<IBIZViewMsg> list);

    boolean update(IBIZViewMsg et);
    boolean updateBatch(List<IBIZViewMsg> list);

    boolean save(IBIZViewMsg et);
    boolean saveBatch(List<IBIZViewMsg> list);

    default boolean remove(String key) {
        IBIZViewMsg et = new IBIZViewMsg();
        et.setIbizViewMsgId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZViewMsg et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZViewMsg> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZViewMsg et = new IBIZViewMsg();
            et.setIbizViewMsgId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZViewMsg> entities);

    Page<IBIZViewMsg> searchDefault(IBIZViewMsgSearchContext context);
    List<IBIZViewMsg> listDefault(IBIZViewMsgSearchContext context);

}