package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
import cn.ibizlab.core.sample.filter.IBIZTASKTEAMSearchContext;
import cn.ibizlab.core.sample.domain.IBIZTASK;

public interface IBIZTASKTEAMService extends IService<IBIZTASKTEAM> {

    default IBIZTASKTEAMService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZTASKTEAM get(IBIZTASKTEAM et);
    default IBIZTASKTEAM get(String key) {
        IBIZTASKTEAM et = new IBIZTASKTEAM();
        et.setIbiztaskteamid(key);
        return getSelf().get(et);
    }
    default List<IBIZTASKTEAM> getByIds(Collection<String> ids) {
        List<IBIZTASKTEAM> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZTASKTEAM et = new IBIZTASKTEAM();
            et.setIbiztaskteamid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZTASKTEAM> getByEntities(List<IBIZTASKTEAM> entities);

    IBIZTASKTEAM getDraft(IBIZTASKTEAM et);

    Integer checkKey(IBIZTASKTEAM et);

    boolean create(IBIZTASKTEAM et);
    boolean createBatch(List<IBIZTASKTEAM> list);

    boolean update(IBIZTASKTEAM et);
    boolean updateBatch(List<IBIZTASKTEAM> list);

    boolean save(IBIZTASKTEAM et);
    boolean saveBatch(List<IBIZTASKTEAM> list);

    default boolean remove(String key) {
        IBIZTASKTEAM et = new IBIZTASKTEAM();
        et.setIbiztaskteamid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZTASKTEAM et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZTASKTEAM> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZTASKTEAM et = new IBIZTASKTEAM();
            et.setIbiztaskteamid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZTASKTEAM> entities);

    default IBIZTASKTEAM createTemp(IBIZTASKTEAM dto) {
        return dto;
    }

    default IBIZTASKTEAM createTempMajor(IBIZTASKTEAM dto) {
        return dto;
    }

    default IBIZTASKTEAM updateTemp(IBIZTASKTEAM dto) {
        return dto;
    }

    default IBIZTASKTEAM updateTempMajor(IBIZTASKTEAM dto) {
        return dto;
    }

    default List<String> removeTemp(List<String> keys) {
        return keys;
    }

    default List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    default IBIZTASKTEAM getTemp(String key) {
        return null;
    }

    default IBIZTASKTEAM getTempMajor(String key) {
        return null;
    }

    default IBIZTASKTEAM getDraftTemp(IBIZTASKTEAM dto) {
        return null;
    }

    default IBIZTASKTEAM getDraftTempMajor(IBIZTASKTEAM dto) {
        return null;
    }

    Page<IBIZTASKTEAM> searchDefault(IBIZTASKTEAMSearchContext context);
    List<IBIZTASKTEAM> listDefault(IBIZTASKTEAMSearchContext context);

    List<IBIZTASKTEAM> selectByRoot(String root);
    boolean removeByRoot(String root);
    boolean resetByRoot(String root);
    boolean saveByTaskTeam(cn.ibizlab.core.sample.domain.IBIZTASK ibiztask,List<IBIZTASKTEAM> list);
    default boolean saveByRoot(String root,List<IBIZTASKTEAM> list) {
        cn.ibizlab.core.sample.domain.IBIZTASK et = new cn.ibizlab.core.sample.domain.IBIZTASK();
        et.setIbiztaskid(root);
        return getSelf().saveByTaskTeam(et,list);
    }

}