package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0019;
import cn.ibizlab.core.sample.filter.IBIZSample0019SearchContext;

public interface IBIZSample0019Service extends IService<IBIZSample0019> {

    default IBIZSample0019Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0019 get(IBIZSample0019 et);
    default IBIZSample0019 get(String key) {
        IBIZSample0019 et = new IBIZSample0019();
        et.setIbizsample0019Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0019> getByIds(Collection<String> ids) {
        List<IBIZSample0019> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0019 et = new IBIZSample0019();
            et.setIbizsample0019Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0019> getByEntities(List<IBIZSample0019> entities);

    IBIZSample0019 getDraft(IBIZSample0019 et);

    Integer checkKey(IBIZSample0019 et);

    boolean create(IBIZSample0019 et);
    boolean createBatch(List<IBIZSample0019> list);

    boolean update(IBIZSample0019 et);
    boolean updateBatch(List<IBIZSample0019> list);

    boolean save(IBIZSample0019 et);
    boolean saveBatch(List<IBIZSample0019> list);

    default boolean remove(String key) {
        IBIZSample0019 et = new IBIZSample0019();
        et.setIbizsample0019Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0019 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0019> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0019 et = new IBIZSample0019();
            et.setIbizsample0019Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0019> entities);

    Page<IBIZSample0019> searchDefault(IBIZSample0019SearchContext context);
    List<IBIZSample0019> listDefault(IBIZSample0019SearchContext context);

}