package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
import cn.ibizlab.core.sample.filter.IBIZSample0002SearchContext;

public interface IBIZSample0002Service extends IService<IBIZSample0002> {

    default IBIZSample0002Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0002 get(IBIZSample0002 et);
    default IBIZSample0002 get(String key) {
        IBIZSample0002 et = new IBIZSample0002();
        et.setIbizSample0002Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0002> getByIds(Collection<String> ids) {
        List<IBIZSample0002> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0002 et = new IBIZSample0002();
            et.setIbizSample0002Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0002> getByEntities(List<IBIZSample0002> entities);

    IBIZSample0002 getDraft(IBIZSample0002 et);

    Integer checkKey(IBIZSample0002 et);

    boolean create(IBIZSample0002 et);
    boolean createBatch(List<IBIZSample0002> list);

    boolean update(IBIZSample0002 et);
    boolean updateBatch(List<IBIZSample0002> list);

    boolean save(IBIZSample0002 et);
    boolean saveBatch(List<IBIZSample0002> list);

    default boolean remove(String key) {
        IBIZSample0002 et = new IBIZSample0002();
        et.setIbizSample0002Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0002 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0002> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0002 et = new IBIZSample0002();
            et.setIbizSample0002Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0002> entities);

    Page<IBIZSample0002> searchDefault(IBIZSample0002SearchContext context);
    List<IBIZSample0002> listDefault(IBIZSample0002SearchContext context);

}