package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZHardware;
/**
 * 关系型数据实体[IBIZHardware] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("硬件")
public class IBIZHardwareSearchContext extends QueryWrapperContext<IBIZHardware> {

    @JsonProperty("n_ibizhardwaretype_eq")
    @JSONField(name = "n_ibizhardwaretype_eq")
    @ApiModelProperty("分组类型EQ")
	private String ibizHardwareTypeEQ;
	public IBIZHardwareSearchContext setIbizHardwareTypeEQ(String ibizHardwareTypeEQ) {
        this.ibizHardwareTypeEQ = ibizHardwareTypeEQ;
        if(!ObjectUtils.isEmpty(this.ibizHardwareTypeEQ)){
            this.getSearchCond().eq("ibizhardwaretype", ibizHardwareTypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizhardwareid_eq")
    @JSONField(name = "n_ibizhardwareid_eq")
    @ApiModelProperty("硬件标识EQ")
	private String ibizHardwareIdEQ;
	public IBIZHardwareSearchContext setIbizHardwareIdEQ(String ibizHardwareIdEQ) {
        this.ibizHardwareIdEQ = ibizHardwareIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizHardwareIdEQ)){
            this.getSearchCond().eq("ibizhardwareid", ibizHardwareIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizhardwarename_like")
    @JSONField(name = "n_ibizhardwarename_like")
    @ApiModelProperty("名称LIKE")
	private String ibizHardwareNameLIKE;
	public IBIZHardwareSearchContext setIbizHardwareNameLIKE(String ibizHardwareNameLIKE) {
        this.ibizHardwareNameLIKE = ibizHardwareNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizHardwareNameLIKE)){
            this.getSearchCond().like("ibizhardwarename", ibizHardwareNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizhardwarename", query)
            );
		}
	}
}