package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0003DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体03")
public class IBIZSample0003DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * FIELD01
     */
    @JsonProperty("field01")
    @JSONField(name = "field01")
    @ApiModelProperty("FIELD01")
    private String field01;

    /**
     * IBIZSAMPLE0003标识
     */
    @JsonProperty("ibizsample0003id")
    @JSONField(name = "ibizsample0003id")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String ibizsample0003Id;

    /**
     * 名称
     */
    @JsonProperty("ibizsample0003name")
    @JSONField(name = "ibizsample0003name")
    @ApiModelProperty("名称")
    private String ibizsample0003Name;

    /**
     * 备注
     */
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 上级
     */
    @JsonProperty("pibizsample0003name")
    @JSONField(name = "pibizsample0003name")
    @ApiModelProperty("上级")
    private String pibizsample0003Name;

    /**
     * IBIZSAMPLE0003标识
     */
    @JsonProperty("pibizsample0003id")
    @JSONField(name = "pibizsample0003id")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String pibizsample0003id;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [FIELD01]
     */
    public void setField01(String field01) {
        this.field01 = field01;
        this.modify("field01", field01);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizsample0003Name(String ibizsample0003Name) {
        this.ibizsample0003Name = ibizsample0003Name;
        this.modify("ibizsample0003name", ibizsample0003Name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [上级]
     */
    public void setPibizsample0003Name(String pibizsample0003Name) {
        this.pibizsample0003Name = pibizsample0003Name;
        this.modify("pibizsample0003name", pibizsample0003Name);
    }

    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setPibizsample0003id(String pibizsample0003id) {
        this.pibizsample0003id = pibizsample0003id;
        this.modify("pibizsample0003id", pibizsample0003id);
    }


}
