package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZStorage;
import cn.ibizlab.core.sample.filter.IBIZStorageSearchContext;
import cn.ibizlab.core.sample.service.IBIZStorageService;
import cn.ibizlab.core.sample.mapper.IBIZStorageMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.service.IBIZHardwareService;


/**
 * 实体[存储] 服务对象接口实现
 */
@Slf4j
@Service("IBIZStorageService")
public class IBIZStorageServiceBase extends ServiceImpl<IBIZStorageMapper,IBIZStorage> implements IBIZStorageService {

    @Autowired
    @Lazy
    protected IBIZHardwareService ibizHardwareService;
   
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.mapping.IBIZStorageInheritMapping ibizStorageInheritMapping;

    protected int batchSize = 500;

    public IBIZStorage get(IBIZStorage et) {
        IBIZStorage rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,存储:"+et.getIbizStorageId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZStorage> getByEntities(List<IBIZStorage> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZStorage getDraft(IBIZStorage et) {
        return et;
    }

    public Integer checkKey(IBIZStorage et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizStorageId())) && this.count(Wrappers.<IBIZStorage>query().eq("ibizstorageid", et.getIbizStorageId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZStorage et) {
        if(ObjectUtils.isEmpty(et.getIbizStorageId()))
            et.setIbizStorageId((String)et.getDefaultKey(true));
        IBIZHardware ibizHardware = ibizStorageInheritMapping.toIbizHardware(et);
        ibizHardwareService.create(ibizHardware);

        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZStorage> list) {
        for (IBIZStorage et : list) {
            getSelf().create(et);
        }
        return true;
    }

    @Transactional
    public boolean update(IBIZStorage et) {
        IBIZHardware ibizHardware = ibizStorageInheritMapping.toIbizHardware(et);
        ibizHardwareService.save(ibizHardware);

        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizstorageid", et.getIbizStorageId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZStorage> list) {
        for (IBIZStorage et : list) {
            getSelf().update(et);
        }
        return true;
    }

    @Transactional
    public boolean save(IBIZStorage et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZStorage> list) {
        List<IBIZStorage> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizStorageId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZStorage> _create=new ArrayList<>();
        List<IBIZStorage> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizStorageId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZStorage et) {
        String key = et.getIbizStorageId();
        ibizHardwareService.remove(ibizStorageInheritMapping.toIbizHardware(et));


        if(!remove(new QueryWrapper<IBIZStorage>()
                .eq("ibizstorageid", et.getIbizStorageId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZStorage> entities) {
        for (IBIZStorage et : entities) {
            if(!getSelf().remove(et))
                return false;
        }
        return true;
    }

    public Page<IBIZStorage> searchDefault(IBIZStorageSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZStorage> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZStorage>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZStorage> listDefault(IBIZStorageSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }