package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.filter.IBIZSample0014SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0014Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0014Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.service.IBIZSample0003Service;


/**
 * 实体[员工] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0014Service")
public class IBIZSample0014ServiceBase extends ServiceImpl<IBIZSample0014Mapper,IBIZSample0014> implements IBIZSample0014Service {

    @Autowired
    @Lazy
    protected IBIZSample0003Service ibizSample0003Service;
   

    protected int batchSize = 500;

    public IBIZSample0014 get(IBIZSample0014 et) {
        IBIZSample0014 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,员工:"+et.getIbizSample0014Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0014> getByEntities(List<IBIZSample0014> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0014 et) {
        if(!ObjectUtils.isEmpty(et.getIbizsample0003Id())) {
            IBIZSample0003 ibizSample0003 = et.getIbizSample0003();
            if(!ObjectUtils.isEmpty(ibizSample0003)) {
                et.setIbizsample0003Name(ibizSample0003.getIbizsample0003Name());   
            }
        }    
    }

    public IBIZSample0014 getDraft(IBIZSample0014 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0014 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0014Id())) && this.count(Wrappers.<IBIZSample0014>query().eq("ibizsample0014id", et.getIbizSample0014Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0014 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0014> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0014 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0014id", et.getIbizSample0014Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0014> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0014 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0014> list) {
        List<IBIZSample0014> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0014Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0014> _create=new ArrayList<>();
        List<IBIZSample0014> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0014Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0014 et) {
        String key = et.getIbizSample0014Id();

        if(!remove(new QueryWrapper<IBIZSample0014>()
                .eq("ibizsample0014id", et.getIbizSample0014Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0014> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0014> searchCurIbizSample0014(IBIZSample0014SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0014> pages=baseMapper.searchCurIbizSample0014(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0014>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0014> listCurIbizSample0014(IBIZSample0014SearchContext context) {
        return baseMapper.listCurIbizSample0014(context,context.getSelectCond());
    }

    public Page<IBIZSample0014> searchDefault(IBIZSample0014SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0014> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0014>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0014> listDefault(IBIZSample0014SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0014> selectByIbizsample0003Id(String ibizsample0003Id) {
        return baseMapper.selectByIbizsample0003Id(ibizsample0003Id);
    }

    public boolean removeByIbizsample0003Id(String ibizsample0003Id) {
        return this.remove(new QueryWrapper<IBIZSample0014>().eq("ibizsample0003id",ibizsample0003Id));
    }

    public boolean resetByIbizsample0003Id(String ibizsample0003Id) {
        return this.update(new UpdateWrapper<IBIZSample0014>().set("ibizsample0003id",null).eq("ibizsample0003id",ibizsample0003Id));
    }

    public boolean saveByIbizSample0003(IBIZSample0003 ibizSample0003,List<IBIZSample0014> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0014> _update=new ArrayList<IBIZSample0014>();
        List<IBIZSample0014> _create=new ArrayList<IBIZSample0014>();
        for(IBIZSample0014 before:selectByIbizsample0003Id(ibizSample0003.getIbizsample0003Id())){
            delIds.add(before.getIbizSample0014Id());
        }
        for(IBIZSample0014 sub:list) {
            sub.setIbizsample0003Id(ibizSample0003.getIbizsample0003Id());
            sub.setIbizSample0003(ibizSample0003);
            if(ObjectUtils.isEmpty(sub.getIbizSample0014Id()))
                sub.setIbizSample0014Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0014Id())) {
                delIds.remove(sub.getIbizSample0014Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }





    }