package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEXTENDEDITORSearchContext;
import cn.ibizlab.core.sample.service.IBIZAPPEXTENDEDITORService;
import cn.ibizlab.core.sample.mapper.IBIZAPPEXTENDEDITORMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[扩展编辑器] 服务对象接口实现
 */
@Slf4j
@Service("IBIZAPPEXTENDEDITORService")
public class IBIZAPPEXTENDEDITORServiceBase extends ServiceImpl<IBIZAPPEXTENDEDITORMapper,IBIZAPPEXTENDEDITOR> implements IBIZAPPEXTENDEDITORService {


    protected int batchSize = 500;

    public IBIZAPPEXTENDEDITOR get(IBIZAPPEXTENDEDITOR et) {
        IBIZAPPEXTENDEDITOR rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,扩展编辑器:"+et.getIbizappextendeditorid());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZAPPEXTENDEDITOR> getByEntities(List<IBIZAPPEXTENDEDITOR> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZAPPEXTENDEDITOR getDraft(IBIZAPPEXTENDEDITOR et) {
        return et;
    }

    public Integer checkKey(IBIZAPPEXTENDEDITOR et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizappextendeditorid())) && this.count(Wrappers.<IBIZAPPEXTENDEDITOR>query().eq("ibizappextendeditorid", et.getIbizappextendeditorid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZAPPEXTENDEDITOR et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZAPPEXTENDEDITOR> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZAPPEXTENDEDITOR et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizappextendeditorid", et.getIbizappextendeditorid());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZAPPEXTENDEDITOR> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZAPPEXTENDEDITOR et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZAPPEXTENDEDITOR> list) {
        List<IBIZAPPEXTENDEDITOR> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizappextendeditorid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZAPPEXTENDEDITOR> _create=new ArrayList<>();
        List<IBIZAPPEXTENDEDITOR> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizappextendeditorid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZAPPEXTENDEDITOR et) {
        String key = et.getIbizappextendeditorid();

        if(!remove(new QueryWrapper<IBIZAPPEXTENDEDITOR>()
                .eq("ibizappextendeditorid", et.getIbizappextendeditorid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZAPPEXTENDEDITOR> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZAPPEXTENDEDITOR> searchDefault(IBIZAPPEXTENDEDITORSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZAPPEXTENDEDITOR> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZAPPEXTENDEDITOR>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZAPPEXTENDEDITOR> listDefault(IBIZAPPEXTENDEDITORSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }