package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0005;
import cn.ibizlab.core.sample.filter.IBIZSample0005SearchContext;

public interface IBIZSample0005Service extends IService<IBIZSample0005> {

    default IBIZSample0005Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0005 get(IBIZSample0005 et);
    default IBIZSample0005 get(String key) {
        IBIZSample0005 et = new IBIZSample0005();
        et.setIbizSample0005Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0005> getByIds(Collection<String> ids) {
        List<IBIZSample0005> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0005 et = new IBIZSample0005();
            et.setIbizSample0005Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0005> getByEntities(List<IBIZSample0005> entities);

    IBIZSample0005 getDraft(IBIZSample0005 et);

    Integer checkKey(IBIZSample0005 et);

    boolean create(IBIZSample0005 et);
    boolean createBatch(List<IBIZSample0005> list);

    boolean update(IBIZSample0005 et);
    boolean updateBatch(List<IBIZSample0005> list);

    boolean save(IBIZSample0005 et);
    boolean saveBatch(List<IBIZSample0005> list);

    default boolean remove(String key) {
        IBIZSample0005 et = new IBIZSample0005();
        et.setIbizSample0005Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0005 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0005> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0005 et = new IBIZSample0005();
            et.setIbizSample0005Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0005> entities);

    Page<IBIZSample0005> searchDefault(IBIZSample0005SearchContext context);
    List<IBIZSample0005> listDefault(IBIZSample0005SearchContext context);

}