package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.filter.IBIZHardwareSearchContext;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

public interface IBIZHardwareService extends IService<IBIZHardware> {

    default IBIZHardwareService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZHardware get(IBIZHardware et);
    default IBIZHardware get(String key) {
        IBIZHardware et = new IBIZHardware();
        et.setIbizHardwareId(key);
        return getSelf().get(et);
    }
    default List<IBIZHardware> getByIds(Collection<String> ids) {
        List<IBIZHardware> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZHardware et = new IBIZHardware();
            et.setIbizHardwareId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZHardware> getByEntities(List<IBIZHardware> entities);

    IBIZHardware getDraft(IBIZHardware et);

    Integer checkKey(IBIZHardware et);

    boolean create(IBIZHardware et);
    boolean createBatch(List<IBIZHardware> list);

    boolean update(IBIZHardware et);
    boolean updateBatch(List<IBIZHardware> list);

    boolean save(IBIZHardware et);
    boolean saveBatch(List<IBIZHardware> list);

    default boolean remove(String key) {
        IBIZHardware et = new IBIZHardware();
        et.setIbizHardwareId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZHardware et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZHardware> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZHardware et = new IBIZHardware();
            et.setIbizHardwareId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZHardware> entities);

    Page<IBIZHardware> searchDefault(IBIZHardwareSearchContext context);
    List<IBIZHardware> listDefault(IBIZHardwareSearchContext context);

}