package cn.ibizlab.core.sample.mapper;

import java.util.List;
import org.apache.ibatis.annotations.*;
import java.util.Map;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.Map;
import org.apache.ibatis.annotations.Select;
import cn.ibizlab.core.sample.domain.IBIZAccount;
import cn.ibizlab.core.sample.filter.IBIZAccountSearchContext;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.alibaba.fastjson.JSONObject;

public interface IBIZAccountMapper extends BaseMapper<IBIZAccount> {


    Page<IBIZAccount> searchDefault(IPage page, @Param("ctx") IBIZAccountSearchContext context, @Param("ew") Wrapper<IBIZAccount> wrapper);
    List<IBIZAccount> listDefault(@Param("ctx") IBIZAccountSearchContext context, @Param("ew") Wrapper<IBIZAccount> wrapper);

    @Override
    IBIZAccount selectById(Serializable id);

    IBIZAccount selectEntity(IBIZAccount entity);

    List<IBIZAccount> selectEntities(@Param("list") List<IBIZAccount> list);

    @Override
    int insert(IBIZAccount entity);

    @Override
    int updateById(@Param(Constants.ENTITY) IBIZAccount entity);

    @Override
    int update(@Param(Constants.ENTITY) IBIZAccount entity, @Param("ew") Wrapper<IBIZAccount> updateWrapper);

    @Override
    int deleteById(Serializable id);

    int deleteEntities(@Param("list") List<IBIZAccount> list);

    /**
    * 自定义查询SQL
    * @param sql
    * @return
    */
    @Select("${sql}")
    List<JSONObject> selectBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义更新SQL
    * @param sql
    * @return
    */
    @Update("${sql}")
    boolean updateBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义插入SQL
    * @param sql
    * @return
    */
    @Insert("${sql}")
    boolean insertBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义删除SQL
    * @param sql
    * @return
    */
    @Delete("${sql}")
    boolean deleteBySQL(@Param("sql") String sql, @Param("et")Map param);

    List<IBIZAccount> selectByIbizAccountId(@Param("ibizAccountId") Serializable ibizAccountId);

}