package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0004;
/**
 * 关系型数据实体[IBIZSample0004] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("多版本流程")
public class IBIZSample0004SearchContext extends QueryWrapperContext<IBIZSample0004> {

    @JsonProperty("n_wfmvstate_eq")
    @JSONField(name = "n_wfmvstate_eq")
    @ApiModelProperty("状态EQ")
	private String wfmvStateEQ;
	public IBIZSample0004SearchContext setWfmvStateEQ(String wfmvStateEQ) {
        this.wfmvStateEQ = wfmvStateEQ;
        if(!ObjectUtils.isEmpty(this.wfmvStateEQ)){
            this.getSearchCond().eq("wfmvstate", wfmvStateEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_wfmvtype_eq")
    @JSONField(name = "n_wfmvtype_eq")
    @ApiModelProperty("订单类型EQ")
	private String wfmvtypeEQ;
	public IBIZSample0004SearchContext setWfmvtypeEQ(String wfmvtypeEQ) {
        this.wfmvtypeEQ = wfmvtypeEQ;
        if(!ObjectUtils.isEmpty(this.wfmvtypeEQ)){
            this.getSearchCond().eq("wfmvtype", wfmvtypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_wfmvstep_eq")
    @JSONField(name = "n_wfmvstep_eq")
    @ApiModelProperty("工作流步骤EQ")
	private String wfmvStepEQ;
	public IBIZSample0004SearchContext setWfmvStepEQ(String wfmvStepEQ) {
        this.wfmvStepEQ = wfmvStepEQ;
        if(!ObjectUtils.isEmpty(this.wfmvStepEQ)){
            this.getSearchCond().eq("wfmvstep", wfmvStepEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0004name_like")
    @JSONField(name = "n_ibizsample0004name_like")
    @ApiModelProperty("名称LIKE")
	private String ibizSample0004NameLIKE;
	public IBIZSample0004SearchContext setIbizSample0004NameLIKE(String ibizSample0004NameLIKE) {
        this.ibizSample0004NameLIKE = ibizSample0004NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0004NameLIKE)){
            this.getSearchCond().like("ibizsample0004name", ibizSample0004NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0004id_eq")
    @JSONField(name = "n_ibizsample0004id_eq")
    @ApiModelProperty("多版本流程标识EQ")
	private String ibizSample0004IdEQ;
	public IBIZSample0004SearchContext setIbizSample0004IdEQ(String ibizSample0004IdEQ) {
        this.ibizSample0004IdEQ = ibizSample0004IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0004IdEQ)){
            this.getSearchCond().eq("ibizsample0004id", ibizSample0004IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0004name", query)
            );
		}
	}
}