package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZCPU;
/**
 * 关系型数据实体[IBIZCPU] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("处理器")
public class IBIZCPUSearchContext extends QueryWrapperContext<IBIZCPU> {

    @JsonProperty("n_ibizcpuid_eq")
    @JSONField(name = "n_ibizcpuid_eq")
    @ApiModelProperty("处理器标识EQ")
	private String ibizcpuidEQ;
	public IBIZCPUSearchContext setIbizcpuidEQ(String ibizcpuidEQ) {
        this.ibizcpuidEQ = ibizcpuidEQ;
        if(!ObjectUtils.isEmpty(this.ibizcpuidEQ)){
            this.getSearchCond().eq("ibizcpuid", ibizcpuidEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizcpuname_like")
    @JSONField(name = "n_ibizcpuname_like")
    @ApiModelProperty("名称LIKE")
	private String ibizcpuNameLIKE;
	public IBIZCPUSearchContext setIbizcpuNameLIKE(String ibizcpuNameLIKE) {
        this.ibizcpuNameLIKE = ibizcpuNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizcpuNameLIKE)){
            this.getSearchCond().like("ibizcpuname", ibizcpuNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizcpuname", query)
            );
		}
	}
}