package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
/**
 * 关系型数据实体[IBIZAPPEXTENDEDITOR] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("扩展编辑器")
public class IBIZAPPEXTENDEDITORSearchContext extends QueryWrapperContext<IBIZAPPEXTENDEDITOR> {

    @JsonProperty("n_ibizappextendeditorname_like")
    @JSONField(name = "n_ibizappextendeditorname_like")
    @ApiModelProperty("扩展编辑器名称LIKE")
	private String ibizappextendeditorNameLIKE;
	public IBIZAPPEXTENDEDITORSearchContext setIbizappextendeditorNameLIKE(String ibizappextendeditorNameLIKE) {
        this.ibizappextendeditorNameLIKE = ibizappextendeditorNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizappextendeditorNameLIKE)){
            this.getSearchCond().like("ibizappextendeditorname", ibizappextendeditorNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizappextendeditorid_eq")
    @JSONField(name = "n_ibizappextendeditorid_eq")
    @ApiModelProperty("扩展编辑器标识EQ")
	private String ibizappextendeditoridEQ;
	public IBIZAPPEXTENDEDITORSearchContext setIbizappextendeditoridEQ(String ibizappextendeditoridEQ) {
        this.ibizappextendeditoridEQ = ibizappextendeditoridEQ;
        if(!ObjectUtils.isEmpty(this.ibizappextendeditoridEQ)){
            this.getSearchCond().eq("ibizappextendeditorid", ibizappextendeditoridEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizappextendeditorname", query)
            );
		}
	}
}