package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
/**
 * 关系型数据实体[IBIZAPPEDITOR] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("编辑器")
public class IBIZAPPEDITORSearchContext extends QueryWrapperContext<IBIZAPPEDITOR> {

    @JsonProperty("n_ibizappeditorname_like")
    @JSONField(name = "n_ibizappeditorname_like")
    @ApiModelProperty("编辑器名称LIKE")
	private String ibizappeditorNameLIKE;
	public IBIZAPPEDITORSearchContext setIbizappeditorNameLIKE(String ibizappeditorNameLIKE) {
        this.ibizappeditorNameLIKE = ibizappeditorNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizappeditorNameLIKE)){
            this.getSearchCond().like("ibizappeditorname", ibizappeditorNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizappeditorid_eq")
    @JSONField(name = "n_ibizappeditorid_eq")
    @ApiModelProperty("编辑器标识EQ")
	private String ibizappeditoridEQ;
	public IBIZAPPEDITORSearchContext setIbizappeditoridEQ(String ibizappeditoridEQ) {
        this.ibizappeditoridEQ = ibizappeditoridEQ;
        if(!ObjectUtils.isEmpty(this.ibizappeditoridEQ)){
            this.getSearchCond().eq("ibizappeditorid", ibizappeditoridEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizappeditorname", query)
            );
		}
	}
}