package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPEDITOR", resultMap = "IBIZAPPEDITORResultMap")
@ApiModel(value = "IBIZAPPEDITOR", description = "编辑器")
public class IBIZAPPEDITOR extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 编辑器名称
     */
    @TableField(value = "ibizappeditorname")
    @DEField(name = "ibizappeditorname")
    @JsonProperty("ibizappeditorname")
    @JSONField(name = "ibizappeditorname")
    @ApiModelProperty(value = "ibizappeditorname", notes = "编辑器名称")
    private String ibizappeditorName;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 编辑器标识
     */
    @Id
    @TableId(value = "ibizappeditorid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizappeditorid" , isKeyField = true)
    @JsonProperty("ibizappeditorid")
    @JSONField(name = "ibizappeditorid")
    @ApiModelProperty(value = "ibizappeditorid", notes = "编辑器标识")
    private String ibizappeditorid;

    /**
     * 编辑器类型
     */
    @TableField(value = "ibizappeditortype")
    @DEField(name = "ibizappeditortype" , dict = "AppEditorType")
    @JsonProperty("ibizappeditortype")
    @JSONField(name = "ibizappeditortype")
    @ApiModelProperty(value = "ibizappeditortype", notes = "编辑器类型")
    private String ibizappeditortype;

    /**
     * 编辑器描述
     */
    @TableField(value = "rditordescription")
    @DEField(name = "rditordescription")
    @JsonProperty("rditordescription")
    @JSONField(name = "rditordescription")
    @ApiModelProperty(value = "rditordescription", notes = "编辑器描述")
    private String rditordescription;

    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @DEField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty(value = "documentaddress", notes = "文档地址")
    private String documentaddress;

    /**
     * 数量
     */
    @TableField(value = "amount")
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "数量")
    private Integer amount;







    /**
     * 设置 [编辑器名称]
     */
    public void setIbizappeditorName(String ibizappeditorName) {
        this.ibizappeditorName = ibizappeditorName;
        this.modify("ibizappeditorname", ibizappeditorName);
    }



    /**
     * 设置 [编辑器类型]
     */
    public void setIbizappeditortype(String ibizappeditortype) {
        this.ibizappeditortype = ibizappeditortype;
        this.modify("ibizappeditortype", ibizappeditortype);
    }

    /**
     * 设置 [编辑器描述]
     */
    public void setRditordescription(String rditordescription) {
        this.rditordescription = rditordescription;
        this.modify("rditordescription", rditordescription);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappeditorid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}