package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
import cn.ibizlab.core.sample.service.IBIZAPPEXTENDEDITORService;
import cn.ibizlab.core.sample.filter.IBIZAPPEXTENDEDITORSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"扩展编辑器" })
@RestController("demoapi-ibizappextendeditor")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZAPPEXTENDEDITORResource {

    @Autowired
    public IBIZAPPEXTENDEDITORService ibizappextendeditorService;

    @Autowired
    @Lazy
    public IBIZAPPEXTENDEDITORDTOMapping ibizappextendeditordtoMapping;


    @ApiOperation(value = "创建Create", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-Create-all') or hasPermission(this.ibizappextendeditordtoMapping.toDomain(#dto),'DemoSys-IBIZAPPEXTENDEDITOR-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> create
            (@Validated @RequestBody IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditordtoMapping.toDomain(dto);
        ibizappextendeditorService.create(domain);
        IBIZAPPEXTENDEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-Get-all') or hasPermission(this.ibizappextendeditordtoMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPEXTENDEDITOR-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappextendeditors/{ibizappextendeditorid}")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> getByIbizappextendeditorid
            (@PathVariable("ibizappextendeditorid") String ibizappextendeditorid) {
        IBIZAPPEXTENDEDITOR rt = ibizappextendeditorService.get(ibizappextendeditorid);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-Remove-all') or hasPermission(this.ibizappextendeditorService.get(#ibizappextendeditorid),'DemoSys-IBIZAPPEXTENDEDITOR-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizappextendeditors/{ibizappextendeditorid}")
    public ResponseEntity<Boolean> removeByIbizappextendeditorid
            (@PathVariable("ibizappextendeditorid") String ibizappextendeditorid) {
        Boolean rt = ibizappextendeditorService.remove(ibizappextendeditorid);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-Update-all') or hasPermission(this.ibizappextendeditorService.get(#ibizappextendeditorid),'DemoSys-IBIZAPPEXTENDEDITOR-Update')")
    @VersionCheck(entity = "ibizappextendeditor" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizappextendeditors/{ibizappextendeditorid}")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> updateByIbizappextendeditorid
            (@PathVariable("ibizappextendeditorid") String ibizappextendeditorid, @Validated @RequestBody IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditordtoMapping.toDomain(dto);
        domain.setIbizappextendeditorid(ibizappextendeditorid);
        ibizappextendeditorService.update(domain);
        IBIZAPPEXTENDEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditordtoMapping.toDomain(dto);
        Integer rt = ibizappextendeditorService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappextendeditors/getdraft")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> getDraft
            (IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditordtoMapping.toDomain(dto);
        IBIZAPPEXTENDEDITOR rt = ibizappextendeditorService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-Save-all') or hasPermission(this.ibizappextendeditordtoMapping.toDomain(#dto),'DemoSys-IBIZAPPEXTENDEDITOR-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors/save")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> save
            (@Validated @RequestBody IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditordtoMapping.toDomain(dto);
        ibizappextendeditorService.save(domain);
        IBIZAPPEXTENDEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"扩展编辑器" },  notes = "IBIZAPPEXTENDEDITOR-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-searchDefault-all','DemoSys-IBIZAPPEXTENDEDITOR-Get-all') or hasPermission(#dto,'DemoSys-IBIZAPPEXTENDEDITOR-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappextendeditors/fetchdefault")
    public ResponseEntity<List<IBIZAPPEXTENDEDITORDTO>> fetchDefault
            (IBIZAPPEXTENDEDITORSearchContext dto) {
        Page<IBIZAPPEXTENDEDITOR> domains = ibizappextendeditorService.searchDefault(dto) ;
        List<IBIZAPPEXTENDEDITORDTO> list = ibizappextendeditordtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEXTENDEDITOR-Create-all')")
    @ApiOperation(value = "批量新建扩展编辑器", tags = {"扩展编辑器" },  notes = "批量新建扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> dtos) {
        ibizappextendeditorService.createBatch(ibizappextendeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEXTENDEDITOR-Update-all')")
    @ApiOperation(value = "批量更新扩展编辑器", tags = {"扩展编辑器" },  notes = "批量更新扩展编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizappextendeditors/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> dtos) {
        ibizappextendeditorService.updateBatch(ibizappextendeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEXTENDEDITOR-Save-all')")
    @ApiOperation(value = "批量保存扩展编辑器", tags = {"扩展编辑器" },  notes = "批量保存扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> dtos) {
        ibizappextendeditorService.saveBatch(ibizappextendeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEXTENDEDITOR-Save-all')")
    @ApiOperation(value = "批量导入扩展编辑器", tags = {"扩展编辑器" },  notes = "批量导入扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappextendeditors/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZAPPEXTENDEDITORDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZAPPEXTENDEDITOR> list=ibizappextendeditordtoMapping.toDomain(dtos);
            List<IBIZAPPEXTENDEDITOR> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizappextendeditorService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEXTENDEDITOR-Remove-all')")
    @ApiOperation(value = "批量删除扩展编辑器", tags = {"扩展编辑器" },  notes = "批量删除扩展编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizappextendeditors","/ibizappextendeditors/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappextendeditorService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
