package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0001DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体01")
public class IBIZSample0001DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 文本，可指定长度
     */
    @JsonProperty("field01")
    @JSONField(name = "field01")
    @ApiModelProperty("文本，可指定长度")
    private String field01;

    /**
     * 长文本，长度1000
     */
    @JsonProperty("field02")
    @JSONField(name = "field02")
    @ApiModelProperty("长文本，长度1000")
    private String field02;

    /**
     * 长文本，没有长度限制
     */
    @JsonProperty("field03")
    @JSONField(name = "field03")
    @ApiModelProperty("长文本，没有长度限制")
    private String field03;

    /**
     * HTML文本，没有长度限制
     */
    @JsonProperty("field04")
    @JSONField(name = "field04")
    @ApiModelProperty("HTML文本，没有长度限制")
    private String field04;

    /**
     * 整型
     */
    @JsonProperty("field05")
    @JSONField(name = "field05")
    @ApiModelProperty("整型")
    private Integer field05;

    /**
     * 浮点
     */
    @JsonProperty("field06")
    @JSONField(name = "field06")
    @ApiModelProperty("浮点")
    private BigDecimal field06;

    /**
     * 数值
     */
    @JsonProperty("field07")
    @JSONField(name = "field07")
    @ApiModelProperty("数值")
    private BigDecimal field07;

    /**
     * 日期时间型
     */
    @JsonProperty("field08")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field08" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("日期时间型")
    private Timestamp field08;

    /**
     * 日期型
     */
    @JsonProperty("field09")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field09" , format = "yyyy-MM-dd")
    @ApiModelProperty("日期型")
    private Timestamp field09;

    /**
     * 时间型
     */
    @JsonProperty("field10")
    @JsonFormat(pattern = "HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field10" , format = "HH:mm:ss")
    @ApiModelProperty("时间型")
    private Timestamp field10;

    /**
     * 是否逻辑
     */
    @JsonProperty("field11")
    @JSONField(name = "field11")
    @ApiModelProperty("是否逻辑")
    private Integer field11;

    /**
     * 真假逻辑
     */
    @JsonProperty("field12")
    @JSONField(name = "field12")
    @ApiModelProperty("真假逻辑")
    private Integer field12;

    /**
     * 单项选择(数值)
     */
    @JsonProperty("field13")
    @JSONField(name = "field13")
    @ApiModelProperty("单项选择(数值)")
    private Integer field13;

    /**
     * 单项选择(文本值)
     */
    @JsonProperty("field14")
    @JSONField(name = "field14")
    @ApiModelProperty("单项选择(文本值)")
    private String field14;

    /**
     * 多项选择(数值)
     */
    @JsonProperty("field15")
    @JSONField(name = "field15")
    @ApiModelProperty("多项选择(数值)")
    private Integer field15;

    /**
     * 多项选择(文本值)
     */
    @JsonProperty("field16")
    @JSONField(name = "field16")
    @ApiModelProperty("多项选择(文本值)")
    private String field16;

    /**
     * 选择项文本
     */
    @JsonProperty("field24")
    @JSONField(name = "field24")
    @ApiModelProperty("选择项文本")
    private String field24;

    /**
     * 数字串业务标识，数字类型，用户可见
     */
    @JsonProperty("field17")
    @JSONField(name = "field17")
    @ApiModelProperty("数字串业务标识，数字类型，用户可见")
    private Integer field17;

    /**
     * 字符串业务标识，文本类型，用户可见
     */
    @JsonProperty("field18")
    @JSONField(name = "field18")
    @ApiModelProperty("字符串业务标识，文本类型，用户可见")
    private String field18;

    /**
     * 货币
     */
    @JsonProperty("field19")
    @JSONField(name = "field19")
    @ApiModelProperty("货币")
    private String field19;

    /**
     * 货币单位
     */
    @JsonProperty("field20")
    @JSONField(name = "field20")
    @ApiModelProperty("货币单位")
    private String field20;

    /**
     * 出生日期
     */
    @JsonProperty("field21")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field21" , format = "yyyy-MM-dd")
    @ApiModelProperty("出生日期")
    private Timestamp field21;

    /**
     * 电子邮件
     */
    @JsonProperty("field22")
    @JSONField(name = "field22")
    @ApiModelProperty("电子邮件")
    private String field22;

    /**
     * 工作流处理状态
     */
    @JsonProperty("field27")
    @JSONField(name = "field27")
    @ApiModelProperty("工作流处理状态")
    private Integer field27;

    /**
     * 地址信息
     */
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty("地址信息")
    private String address;

    /**
     * 城市
     */
    @JsonProperty("city")
    @JSONField(name = "city")
    @ApiModelProperty("城市")
    private String city;

    /**
     * 颜色
     */
    @JsonProperty("color")
    @JSONField(name = "color")
    @ApiModelProperty("颜色")
    private String color;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 磁盘图片
     */
    @JsonProperty("diskimg")
    @JSONField(name = "diskimg")
    @ApiModelProperty("磁盘图片")
    private String diskimg;

    /**
     * 大整型
     */
    @JsonProperty("field")
    @JSONField(name = "field")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("大整型")
    private Long field;

    /**
     * 大数值
     */
    @JsonProperty("field2")
    @JSONField(name = "field2")
    @ApiModelProperty("大数值")
    private BigDecimal field2;

    /**
     * IBIZSAMPLE0001标识
     */
    @JsonProperty("ibizsample0001id")
    @JSONField(name = "ibizsample0001id")
    @ApiModelProperty("IBIZSAMPLE0001标识")
    private String ibizSample0001Id;

    /**
     * 名称
     */
    @JsonProperty("ibizsample0001name")
    @JSONField(name = "ibizsample0001name")
    @ApiModelProperty("名称")
    private String ibizSample0001Name;

    /**
     * 首页图表数据源标识
     */
    @JsonProperty("ibizsample0002id")
    @JSONField(name = "ibizsample0002id")
    @ApiModelProperty("首页图表数据源标识")
    private String ibizSample0002Id;

    /**
     * 示例实体02名称
     */
    @JsonProperty("ibizsample0002name")
    @JSONField(name = "ibizsample0002name")
    @ApiModelProperty("示例实体02名称")
    private String ibizSample0002Name;

    /**
     * IP地址
     */
    @JsonProperty("ip")
    @JSONField(name = "ip")
    @ApiModelProperty("IP地址")
    private String ip;

    /**
     * 纬度
     */
    @JsonProperty("latitude")
    @JSONField(name = "latitude")
    @ApiModelProperty("纬度")
    private String latitude;

    /**
     * 经度
     */
    @JsonProperty("longitude")
    @JSONField(name = "longitude")
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 图片
     */
    @JsonProperty("picture")
    @JSONField(name = "picture")
    @ApiModelProperty("图片")
    private String picture;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [文本，可指定长度]
     */
    public void setField01(String field01) {
        this.field01 = field01;
        this.modify("field01", field01);
    }

    /**
     * 设置 [长文本，长度1000]
     */
    public void setField02(String field02) {
        this.field02 = field02;
        this.modify("field02", field02);
    }

    /**
     * 设置 [长文本，没有长度限制]
     */
    public void setField03(String field03) {
        this.field03 = field03;
        this.modify("field03", field03);
    }

    /**
     * 设置 [HTML文本，没有长度限制]
     */
    public void setField04(String field04) {
        this.field04 = field04;
        this.modify("field04", field04);
    }

    /**
     * 设置 [整型]
     */
    public void setField05(Integer field05) {
        this.field05 = field05;
        this.modify("field05", field05);
    }

    /**
     * 设置 [浮点]
     */
    public void setField06(BigDecimal field06) {
        this.field06 = field06;
        this.modify("field06", field06);
    }

    /**
     * 设置 [数值]
     */
    public void setField07(BigDecimal field07) {
        this.field07 = field07;
        this.modify("field07", field07);
    }

    /**
     * 设置 [日期时间型]
     */
    public void setField08(Timestamp field08) {
        this.field08 = field08;
        this.modify("field08", field08);
    }

    /**
     * 设置 [日期型]
     */
    public void setField09(Timestamp field09) {
        this.field09 = field09;
        this.modify("field09", field09);
    }

    /**
     * 设置 [时间型]
     */
    public void setField10(Timestamp field10) {
        this.field10 = field10;
        this.modify("field10", field10);
    }

    /**
     * 设置 [是否逻辑]
     */
    public void setField11(Integer field11) {
        this.field11 = field11;
        this.modify("field11", field11);
    }

    /**
     * 设置 [真假逻辑]
     */
    public void setField12(Integer field12) {
        this.field12 = field12;
        this.modify("field12", field12);
    }

    /**
     * 设置 [单项选择(数值)]
     */
    public void setField13(Integer field13) {
        this.field13 = field13;
        this.modify("field13", field13);
    }

    /**
     * 设置 [单项选择(文本值)]
     */
    public void setField14(String field14) {
        this.field14 = field14;
        this.modify("field14", field14);
    }

    /**
     * 设置 [多项选择(数值)]
     */
    public void setField15(Integer field15) {
        this.field15 = field15;
        this.modify("field15", field15);
    }

    /**
     * 设置 [多项选择(文本值)]
     */
    public void setField16(String field16) {
        this.field16 = field16;
        this.modify("field16", field16);
    }

    /**
     * 设置 [选择项文本]
     */
    public void setField24(String field24) {
        this.field24 = field24;
        this.modify("field24", field24);
    }

    /**
     * 设置 [数字串业务标识，数字类型，用户可见]
     */
    public void setField17(Integer field17) {
        this.field17 = field17;
        this.modify("field17", field17);
    }

    /**
     * 设置 [字符串业务标识，文本类型，用户可见]
     */
    public void setField18(String field18) {
        this.field18 = field18;
        this.modify("field18", field18);
    }

    /**
     * 设置 [货币]
     */
    public void setField19(String field19) {
        this.field19 = field19;
        this.modify("field19", field19);
    }

    /**
     * 设置 [货币单位]
     */
    public void setField20(String field20) {
        this.field20 = field20;
        this.modify("field20", field20);
    }

    /**
     * 设置 [出生日期]
     */
    public void setField21(Timestamp field21) {
        this.field21 = field21;
        this.modify("field21", field21);
    }

    /**
     * 设置 [电子邮件]
     */
    public void setField22(String field22) {
        this.field22 = field22;
        this.modify("field22", field22);
    }

    /**
     * 设置 [工作流处理状态]
     */
    public void setField27(Integer field27) {
        this.field27 = field27;
        this.modify("field27", field27);
    }

    /**
     * 设置 [地址信息]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [城市]
     */
    public void setCity(String city) {
        this.city = city;
        this.modify("city", city);
    }

    /**
     * 设置 [颜色]
     */
    public void setColor(String color) {
        this.color = color;
        this.modify("color", color);
    }

    /**
     * 设置 [磁盘图片]
     */
    public void setDiskimg(String diskimg) {
        this.diskimg = diskimg;
        this.modify("diskimg", diskimg);
    }

    /**
     * 设置 [大整型]
     */
    public void setField(Long field) {
        this.field = field;
        this.modify("field", field);
    }

    /**
     * 设置 [大数值]
     */
    public void setField2(BigDecimal field2) {
        this.field2 = field2;
        this.modify("field2", field2);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizSample0001Name(String ibizSample0001Name) {
        this.ibizSample0001Name = ibizSample0001Name;
        this.modify("ibizsample0001name", ibizSample0001Name);
    }

    /**
     * 设置 [首页图表数据源标识]
     */
    public void setIbizSample0002Id(String ibizSample0002Id) {
        this.ibizSample0002Id = ibizSample0002Id;
        this.modify("ibizsample0002id", ibizSample0002Id);
    }

    /**
     * 设置 [示例实体02名称]
     */
    public void setIbizSample0002Name(String ibizSample0002Name) {
        this.ibizSample0002Name = ibizSample0002Name;
        this.modify("ibizsample0002name", ibizSample0002Name);
    }

    /**
     * 设置 [IP地址]
     */
    public void setIp(String ip) {
        this.ip = ip;
        this.modify("ip", ip);
    }

    /**
     * 设置 [纬度]
     */
    public void setLatitude(String latitude) {
        this.latitude = latitude;
        this.modify("latitude", latitude);
    }

    /**
     * 设置 [经度]
     */
    public void setLongitude(String longitude) {
        this.longitude = longitude;
        this.modify("longitude", longitude);
    }

    /**
     * 设置 [图片]
     */
    public void setPicture(String picture) {
        this.picture = picture;
        this.modify("picture", picture);
    }


}
